/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.inspector;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.database.DatabaseServiceCore;
import eu.dnetlib.enabling.database.inspector.AbstractController;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class DatabaseAPIController
extends AbstractController {
    @Resource
    private DatabaseServiceCore core;
    private String db;

    @RequestMapping(value={"describeDatabase.do"})
    public void describeDatabase(ServletResponse response) throws Exception {
        Element root = DocumentHelper.createElement((String)"database");
        root.addAttribute("name", this.db);
        for (String table : this.core.getDbUtils().listCommonDBTables(this.db)) {
            Element tnode = root.addElement("table");
            tnode.addAttribute("name", table);
            for (Map info : this.core.getDbUtils().describeTable(this.db, table)) {
                Element colnode = tnode.addElement("column");
                colnode.addAttribute("name", "" + info.get("column_name"));
                for (Map.Entry entry : info.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    colnode.addElement(entry.getKey().toString()).addText(entry.getValue().toString());
                }
            }
        }
        this.sendFile(response, root.asXML(), "text/xml");
    }

    @RequestMapping(value={"dumpTable.do"})
    public void dumpTable(ServletResponse response, @RequestParam(value="table", required=true) String table) throws Exception {
        this.sendFile(response, this.core.getDbUtils().dumpTableAsXML(this.db, table), "text/xml");
    }

    @RequestMapping(value={"populateDatabase.do"})
    public void populateDatabase(ServletResponse response, @RequestParam(value="rows", required=false) String rows) throws Exception {
        if (rows == null) {
            this.sendFile(response, this.getClass().getResourceAsStream("/eu/dnetlib/enabling/database/inspector/web/html/populateAPI.html"), "text/html");
            return;
        }
        long start = DateUtils.now();
        this.core.importFromIterable(this.db, (Iterable)Lists.newArrayList((Object[])new String[]{rows}));
        long end = DateUtils.now();
        this.sendFile(response, "<done time =\"" + HumanTime.exactly((long)(end - start)) + "\" />", "text/xml");
    }

    public String getDb() {
        return this.db;
    }

    @Required
    public void setDb(String db) {
        this.db = db;
    }
}

