/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.inspector;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.database.DatabaseServiceCore;
import eu.dnetlib.enabling.database.inspector.AbstractController;
import eu.dnetlib.enabling.database.resultset.IterableRowSet;
import eu.dnetlib.enabling.inspector.EntryPointDescriptor;
import eu.dnetlib.enabling.inspector.EntryPointDescriptorGroup;
import eu.dnetlib.enabling.inspector.EntryPointDescriptorModel;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class DatabaseController
extends AbstractController {
    @Resource
    private DatabaseServiceCore core;
    private static final Log log = LogFactory.getLog(DatabaseController.class);
    @Resource
    List<EntryPointDescriptorGroup> entryPointsGroups;
    private String DB_INSPECTOR_NAME = "db";

    @RequestMapping(value={"index.do"})
    public void index(ModelMap map) {
    }

    @RequestMapping(value={"listDBs.do"})
    public void listDatabases(ModelMap map) throws Exception {
        map.addAttribute("list", (Object)this.core.listDatabases());
    }

    @RequestMapping(value={"listTables.do"})
    public void listTables(ModelMap map, @RequestParam(value="db", required=true) String db) throws Exception {
        map.addAttribute("db", (Object)db);
        ArrayList tables = new ArrayList();
        HashMap<String, String> logSize = new HashMap<String, String>();
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("tables_info.sql"), (Writer)sw);
        SqlRowSet rows = (SqlRowSet)this.core.getDbUtils().executeSql(db, sw.toString(), SqlRowSet.class);
        while (rows.next()) {
            String tname = rows.getString("name");
            if (tname.endsWith("_log")) {
                logSize.put(tname.substring(0, tname.length() - 4), rows.getString("total"));
                continue;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", rows.getString("name"));
            hashMap.put("view", rows.getString("kind").equalsIgnoreCase("v"));
            hashMap.put("data", rows.getString("data"));
            hashMap.put("indices", rows.getString("indices"));
            hashMap.put("total", rows.getString("total"));
            hashMap.put("managed", this.core.getDbUtils().isManagedTable(db, tname));
            hashMap.put("logged", this.core.getDbUtils().isLoggedTable(db, tname));
            hashMap.put("dnetIdentifier", this.core.getDbUtils().getDefaultDnetIdentifier(db, tname));
            tables.add(hashMap);
        }
        for (Map map2 : tables) {
            if (logSize.containsKey(map2.get("name"))) {
                map2.put("logdata", logSize.get(map2.get("name")));
                continue;
            }
            map2.put("logdata", "-");
        }
        map.addAttribute("tables", tables);
    }

    @RequestMapping(value={"manageDB.do"})
    public String manageDB(ModelMap map, @RequestParam(value="db", required=true) String db, @RequestParam(value="manage", required=true) boolean b) throws Exception {
        this.core.changeDatabaseStatus(db, b);
        return "redirect:listDBs.do";
    }

    @RequestMapping(value={"importEPR.do"})
    public void importEPR(ModelMap map, @RequestParam(value="db", required=false) String db, @RequestParam(value="epr", required=false) String epr) throws Exception {
        if (db != null && epr != null) {
            this.core.importFromResultset(db, new EPRUtils().getEpr(epr));
            map.addAttribute("message", (Object)"Import completed");
        }
        map.addAttribute("list", (Object)this.core.listDatabases());
    }

    @RequestMapping(value={"query.do"})
    public void query(ModelMap map, @RequestParam(value="query", required=false) String query, @RequestParam(value="db", required=false) String db, @RequestParam(value="limit", required=false) Integer limit) throws Exception {
        if (limit == null) {
            limit = 10;
        }
        map.addAttribute("databases", (Object)this.core.getDbUtils().listAllDatabases());
        map.addAttribute("limit", (Object)limit);
        map.addAttribute("db", (Object)"");
        if (query != null && db != null && query.length() > 0 && db.length() > 0) {
            map.addAttribute("query", (Object)query);
            map.addAttribute("db", (Object)db);
            try {
                map.addAttribute("list", (Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)new IterableRowSet(db, query, null, this.core.getDbUtils()), (int)limit)));
            }
            catch (Exception e) {
                map.addAttribute("message", (Object)("<b>ERROR:</b> " + e.getMessage() + " (" + e.getClass() + ")"));
                log.error((Object)"Error executing query", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"changeTableManagement.do"})
    public String changeTableManagement(ModelMap map, @RequestParam(value="db", required=true) String db, @RequestParam(value="t", required=true) String t) throws Exception {
        if (this.core.getDbUtils().isManagedTable(db, t)) {
            this.core.getDbUtils().removeManagementOfTable(db, t);
        } else {
            this.core.getDbUtils().prepareManagementOfTable(db, t);
        }
        return "redirect:listTables.do?db=" + db;
    }

    @RequestMapping(value={"changeIdentifiers.do"})
    public String changeId(HttpServletResponse res, @RequestParam(value="db", required=true) String db, @RequestParam(value="t", required=false) String t) throws Exception {
        if (t == null) {
            this.core.getDbUtils().reassignDefaultDnetIdentifiers(db);
            return "redirect:listDBs.do";
        }
        this.core.getDbUtils().reassignDefaultDnetIdentifiers(db, t);
        return "redirect:listTables.do?db=" + db;
    }

    @RequestMapping(value={"changeTableLog.do"})
    public String changeTableLog(ModelMap map, @RequestParam(value="db", required=true) String db, @RequestParam(value="t", required=true) String t) throws Exception {
        if (this.core.getDbUtils().isManagedTable(db, t)) {
            if (this.core.getDbUtils().isLoggedTable(db, t)) {
                this.core.getDbUtils().removeLogTable(db, t);
            } else {
                this.core.getDbUtils().addLogTable(db, t);
            }
        }
        return "redirect:listTables.do?db=" + db;
    }

    @RequestMapping(value={"describeTable.do"})
    public void describeTable(ModelMap map, @RequestParam(value="db", required=true) String db, @RequestParam(value="t", required=true) String t) throws Exception {
        map.addAttribute("db", (Object)db);
        map.addAttribute("table", (Object)t);
        map.addAttribute("description", (Object)this.core.getDbUtils().describeTable(db, t));
    }

    @RequestMapping(value={"dumpTable.do"})
    public void dumpTable(ServletResponse response, @RequestParam(value="db", required=true) String db, @RequestParam(value="t", required=true) String t) throws Exception {
        this.sendFile(response, this.core.getDbUtils().dumpTableAsXML(db, t), "text/xml");
    }

    @RequestMapping(value={"getTableEPR.do"})
    public void getTableEPR(ServletResponse response, @RequestParam(value="db", required=true) String db, @RequestParam(value="t", required=true) String t) throws Exception {
        this.sendFile(response, this.core.generateResultSet(db, t, null).toString(), "text/xml");
    }

    @RequestMapping(value={"dumpEPR.do"})
    public void dumpEPR(ModelMap map, @RequestParam(value="epr", required=false) String eprText) throws Exception {
        if (eprText != null) {
            W3CEndpointReference epr = new EPRUtils().getEpr(eprText);
            IterableResultSetClient client = this.core.getClientResultSetFactory().getClient(epr);
            map.addAttribute("epr", (Object)eprText);
            map.addAttribute("iter", (Object)client.iterator());
        }
    }

    @RequestMapping(value={"getConditionalEPR.do"})
    public void getConditionalEPR(ServletResponse response, @RequestParam(value="db", required=true) String db, @RequestParam(value="table", required=true) String t, @RequestParam(value="where", required=true) String where) throws Exception {
        log.info((Object)("Requested EPR of table " + t + " where " + where));
        this.sendFile(response, this.core.generateResultSet(db, t, where).toString(), "text/xml");
    }

    @ModelAttribute(value="otherMenu")
    public List<EntryPointDescriptorModel> obtainOtherMenu(HttpServletRequest request) {
        if (this.entryPointsGroups == null) {
            return null;
        }
        ArrayList<EntryPointDescriptorModel> menu = new ArrayList<EntryPointDescriptorModel>();
        final String currentRelativeUrl = request.getPathInfo().replaceAll("/inspector/(.*\\.do).*", "$1");
        UnaryFunction<EntryPointDescriptorModel, EntryPointDescriptor> mapper = new UnaryFunction<EntryPointDescriptorModel, EntryPointDescriptor>(){

            public EntryPointDescriptorModel evaluate(EntryPointDescriptor arg) {
                return new EntryPointDescriptorModel(arg.getName(), arg.getRelativeUrl(), currentRelativeUrl.equals(arg.getRelativeUrl()));
            }
        };
        for (EntryPointDescriptorGroup group : this.entryPointsGroups) {
            ArrayList list = Lists.newArrayList((Iterable)new MappedCollection(group.getDescriptors(), (UnaryFunction)mapper));
            for (EntryPointDescriptorModel model : list) {
                if (model.getName().equals(this.DB_INSPECTOR_NAME)) continue;
                menu.add(model);
            }
        }
        return menu;
    }

    public void setDB_INSPECTOR_NAME(String dBINSPECTORNAME) {
        this.DB_INSPECTOR_NAME = dBINSPECTORNAME;
    }
}

