package eu.dnetlib.enabling.database.inspector;

import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.ServletResponse;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.google.common.collect.Lists;

import eu.dnetlib.enabling.database.DatabaseServiceCore;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.datetime.HumanTime;

public class DatabaseAPIController extends AbstractController {
	@Resource
	private DatabaseServiceCore core;
	
	private String db;
	
	@RequestMapping("describeDatabase.do")
	public void describeDatabase(final ServletResponse response) throws Exception {
		Element root = DocumentHelper.createElement("database");
		root.addAttribute("name", db);
		
		for (String table : core.getDbUtils().listCommonDBTables(db)) {
			Element tnode = root.addElement("table");
			tnode.addAttribute("name", table);
			for (Map<?, ?> info : core.getDbUtils().describeTable(db, table)) {
				Element colnode = tnode.addElement("column");
				colnode.addAttribute("name", "" + info.get("column_name"));
				for (Map.Entry<?,?> entry : info.entrySet()) {
					if (entry.getKey() != null && entry.getValue() != null) {
						colnode.addElement(entry.getKey().toString()).addText(entry.getValue().toString());
					}
				}
			}
		}
		
		sendFile(response, root.asXML(), CTYPE_XML);
	}
	
	@RequestMapping("dumpTable.do")
	public void dumpTable(final ServletResponse response, @RequestParam(value = "table", required = true) final String table) throws Exception {
		sendFile(response, core.getDbUtils().dumpTableAsXML(db, table), CTYPE_XML);
	}
	
	@RequestMapping("populateDatabase.do")
	public void populateDatabase(final ServletResponse response,
			@RequestParam(value = "rows", required=false) final String rows) throws Exception {
		
		if (rows == null) {
			sendFile(response, getClass().getResourceAsStream("/eu/dnetlib/enabling/database/inspector/web/html/populateAPI.html"), CTYPE_HTML);
			return;
		} 
		
		long start = DateUtils.now();
		core.importFromIterable(db, Lists.newArrayList(rows));
		long end = DateUtils.now();
		
		sendFile(response, "<done time =\"" + HumanTime.exactly(end-start) + "\" />", CTYPE_XML);
	}
	
	public String getDb() {
		return db;
	}

	@Required
	public void setDb(String db) {
		this.db = db;
	}
	
}
