SELECT c.relname AS name, 
		c.relkind as kind,
		pg_size_pretty(pg_relation_size(c.relname::text)) AS data,
		pg_size_pretty(pg_total_relation_size(c.relname::text)-pg_relation_size(c.relname::text)) AS indices,
		pg_size_pretty(pg_total_relation_size(c.relname::text)) AS total
FROM pg_class c
LEFT JOIN pg_namespace n ON n.oid = c.relnamespace
WHERE c.relkind IN ('r','v','')
	AND n.nspname NOT IN ('pg_catalog', 'pg_toast')
	AND pg_table_is_visible(c.oid)
ORDER BY c.relname;