package eu.dnetlib.enabling.ui.common.services;

import com.google.gwt.user.client.rpc.RemoteService;

/**
 * Allows client gwt code to check if a user can be authenticated and obtains an authenticated session.
 * 
 * @author michele
 * 
 */
public interface AuthenticationService extends RemoteService {
	/**
	 * Authenticate a user.
	 * 
	 * @param login
	 *            login principal
	 * @param password
	 *            cleartext password
	 * @return session id or empty string if authentication fails.
	 * @throws MyGwtException
	 */
	String authenticate(String login, String password) throws MyGwtException;

	/**
	 * Checks whether an already logged in user is authorized to work with the interface backed with this authentication
	 * service.
	 * 
	 * @param session
	 *            principal is identifier with the session id
	 * @return true if authorized
	 */
	boolean authorize(String session);

	/**
	 * 
	 * @param session
	 * @param property
	 * @return property value
	 */
	public String getAuthenticationProperty(String session, String property);
}
