package eu.dnetlib.enabling.ui.common.services;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;

import eu.dnetlib.enabling.ui.common.beans.AllDSInfo;
import eu.dnetlib.enabling.ui.common.beans.BlackBoardInfo;
import eu.dnetlib.enabling.ui.common.beans.CountryInfo;
import eu.dnetlib.enabling.ui.common.beans.DHNInfo;
import eu.dnetlib.enabling.ui.common.beans.IndexInfo;
import eu.dnetlib.enabling.ui.common.beans.MDStoreInfo;
import eu.dnetlib.enabling.ui.common.beans.RepositoryDetailsInfo;
import eu.dnetlib.enabling.ui.common.beans.RepositoryStatusInfo;
import eu.dnetlib.enabling.ui.common.beans.ServiceInfo;
import eu.dnetlib.enabling.ui.common.beans.UnibiServiceInfo;




public interface LookupService extends RemoteService {
	public Map<String,String> loadCountries() throws MyGwtException;
	public List<String> executeQuery(String query) throws MyGwtException;
	public List<ServiceInfo> listServices() throws MyGwtException;
	public List<String> listSchemas() throws MyGwtException;
	public List<DHNInfo> listDHNs() throws MyGwtException;
	public List<AllDSInfo> infoDataStructures() throws MyGwtException;
	public List<Map<String, String>> listDataStructures(String type) throws MyGwtException;
	public List<RepositoryStatusInfo> listRepositories(boolean withTransformator) throws MyGwtException;
	public List<RepositoryStatusInfo> listRepositoriesForUser(String session, boolean withTransformator) throws MyGwtException;
	public RepositoryDetailsInfo getRepositoryDetailsInfo(String id,  boolean withTransformator) throws MyGwtException;
	public List<MDStoreInfo> getMDStoreInfo(List<String> ids) throws MyGwtException;
	public List<Map<String, String>> listRecentDataStructures(int limit) throws MyGwtException;
	public List<IndexInfo> getOldOrDuplicatedIndexes() throws MyGwtException;
	public Map<String, List<Map<String, String>>> cleanUP(Boolean delete) throws MyGwtException;
	public List<UnibiServiceInfo> listAggregators() throws MyGwtException;
	public List<BlackBoardInfo> listBlackboards() throws MyGwtException;
	public List<String> listIndeces() throws MyGwtException;
	public List<CountryInfo> listCountries() throws MyGwtException;
	public List<UnibiServiceInfo> listTransformators() throws MyGwtException;
	public List<UnibiServiceInfo> listHarvesters() throws MyGwtException;
	public List<String> listAggregatorsForUser(String session) throws MyGwtException;
	@Deprecated public List<String> listMetadataFormats();
}
