package eu.dnetlib.enabling.ui.common.services;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.AsyncCallback;
import eu.dnetlib.enabling.ui.common.beans.*;




public interface LookupServiceAsync {
	public void loadCountries(AsyncCallback<Map<String,String>> callback);
	public void executeQuery(String query, AsyncCallback<List<String>> callback);
	public void listServices(AsyncCallback<List<ServiceInfo>> callback);
	public void listSchemas(AsyncCallback<List<String>> callback);
	public void listDHNs(AsyncCallback<List<DHNInfo>> callback);
	public void infoDataStructures(AsyncCallback<List<AllDSInfo>> callback);
	public void listDataStructures(String type, AsyncCallback<List<Map<String, String>>> callback);
	public void listRepositories(boolean withTransformator, AsyncCallback<List<RepositoryStatusInfo>> callback);
	public void listRepositoriesForUser(String session, boolean withTransformator, AsyncCallback<List<RepositoryStatusInfo>> callback);
	public void getRepositoryDetailsInfo(String id, boolean withTransformator, AsyncCallback<RepositoryDetailsInfo> callback);
	public void getMDStoreInfo(List<String> ids, AsyncCallback<List<MDStoreInfo>> callback);
	public void listRecentDataStructures(int limit, AsyncCallback<List<Map<String, String>>> callback);
	public void getOldOrDuplicatedIndexes(AsyncCallback<List<IndexInfo>> callback);
	public void cleanUP(Boolean delete, AsyncCallback<Map<String, List<Map<String, String>>>> callback);
	public void listAggregators(AsyncCallback<List<UnibiServiceInfo>> callback);
	public void listBlackboards(AsyncCallback<List<BlackBoardInfo>> callback);
	public void listIndeces(AsyncCallback<List<String>> callback);
	public void listCountries(AsyncCallback<List<CountryInfo>> callback);
	public void listTransformators(AsyncCallback<List<UnibiServiceInfo>> callback);
	public void listHarvesters(AsyncCallback<List<UnibiServiceInfo>> callback);
	public void listAggregatorsForUser(String session, AsyncCallback<List<String>> asyncCallback);
	@Deprecated public void listMetadataFormats(AsyncCallback<List<String>> callback);
}
