/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FindExtraFieldValueJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(FindExtraFieldValueJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String envTargetAttributeName;
    private String extraFieldName;

    public void execute(Engine engine, NodeToken token) {
        Env env = token.getFullEnv();
        String repoId = env.getAttribute("repositoryId");
        String extraFieldValue = null;
        try {
            List values = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value ='" + repoId + "']//EXTRA_FIELDS/FIELD[./key/string() = '" + this.extraFieldName + "']/value/string()");
            if (!values.isEmpty()) {
                extraFieldValue = (String)values.get(0);
            }
            log.debug((Object)(this.extraFieldName + " = " + extraFieldValue));
            env.setAttribute(this.envTargetAttributeName, extraFieldValue);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getEnvTargetAttributeName() {
        return this.envTargetAttributeName;
    }

    public void setEnvTargetAttributeName(String envTargetAttributeName) {
        this.envTargetAttributeName = envTargetAttributeName;
    }

    public String getExtraFieldName() {
        return this.extraFieldName;
    }

    public void setExtraFieldName(String extraFieldName) {
        this.extraFieldName = extraFieldName;
    }
}

