/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class TagAssignerNotificationHandler
extends AbstractWorkflowLauncherNotificationHandler {
    private static final Log log = LogFactory.getLog(TagAssignerNotificationHandler.class);
    @Resource
    protected MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
        log.info((Object)("mdstore source id " + rsId));
        env.setAttribute("mdId", rsId);
        env.setAttribute("dataSource", this.sourceDescriptionGenerator.generateDataSourceDescriptor(rsId));
        try {
            String repoQuery = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + rsId + "' or contains(.//DATA_SINK, '" + rsId + "')]//REPOSITORY_SERVICE_IDENTIFIER/text()";
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(repoQuery);
            log.debug((Object)("got repository profile " + repId));
            env.setAttribute("repositoryId", repId);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.warn((Object)("cannot locate the repository associated with the mdstore " + rsId), (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.warn((Object)("cannot locate the repository associated with the mdstore " + rsId), (Throwable)e);
        }
    }

    public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
        return this.sourceDescriptionGenerator;
    }

    public void setSourceDescriptionGenerator(MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
        this.sourceDescriptionGenerator = sourceDescriptionGenerator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

