/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class TransformRecords
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(TransformRecords.class);
    private XSLTMappedResultSetFactory xsltRSFactory;
    private ServiceResolver serviceResolver;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private DataSourceResolver dataSourceResolver;
    private String actionIfNotFound = "failed";
    private String outputEprAttributeName = "transformedEpr";

    public void execute(Engine engine, NodeToken token) {
        Env env = token.getFullEnv();
        String tdsId = env.getAttribute("tdsId");
        log.fatal((Object)("TDS id = " + tdsId));
        String dataSource = token.getFullEnv().getAttribute("dataSource");
        String queryCodeRule = "let $ruleID := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + tdsId + "']//BODY/CONFIGURATION/TRANSFORMATION_RULE_DS_IDENTIFIER/string() " + "return //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=$ruleID]/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
        W3CEndpointReference mdStoreRsetEpr = null;
        try {
            mdStoreRsetEpr = this.dataSourceResolver.resolve(dataSource).retrieve();
            String xsltCode = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(queryCodeRule);
            if (xsltCode == null || xsltCode.isEmpty()) {
                log.fatal((Object)"TDS has a rule to apply, but the TransformationRuleDSProfile has no code: no transformation will be applied");
                token.getEnv().setAttribute("mdstoreNativeEprString", mdStoreRsetEpr.toString());
                token.getEnv().setTransientAttribute("mdstoreNative", (Object)mdStoreRsetEpr);
                token.getEnv().setAttribute(this.outputEprAttributeName + "String", mdStoreRsetEpr.toString());
                token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)mdStoreRsetEpr);
            }
            log.debug((Object)xsltCode);
            W3CEndpointReference transformedEpr = this.xsltRSFactory.createMappedResultSet(mdStoreRsetEpr, (Source)new StreamSource(IOUtils.toInputStream((String)xsltCode)));
            token.getEnv().setAttribute("mdstoreNativeEprString", mdStoreRsetEpr.toString());
            token.getEnv().setTransientAttribute("mdstoreNative", (Object)mdStoreRsetEpr);
            token.getEnv().setAttribute(this.outputEprAttributeName + "String", transformedEpr.toString());
            token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)transformedEpr);
            log.warn((Object)("Transformed epr " + transformedEpr.toString()));
        }
        catch (ISLookUpDocumentNotFoundException e) {
            if (this.actionIfNotFound.equals("failed")) {
                this.failed(engine, token, e);
            } else {
                log.debug((Object)"TransformationRuleDSProfile not found, no transformation will be applied");
                token.getEnv().setAttribute("mdstoreNativeEprString", mdStoreRsetEpr.toString());
                token.getEnv().setTransientAttribute("mdstoreNative", (Object)mdStoreRsetEpr);
                token.getEnv().setAttribute(this.outputEprAttributeName + "String", mdStoreRsetEpr.toString());
                token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)mdStoreRsetEpr);
            }
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public XSLTMappedResultSetFactory getXsltRSFactory() {
        return this.xsltRSFactory;
    }

    @Required
    public void setXsltRSFactory(XSLTMappedResultSetFactory xsltRSFactory) {
        this.xsltRSFactory = xsltRSFactory;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public String getActionIfNotFound() {
        return this.actionIfNotFound;
    }

    public void setActionIfNotFound(String actionIfNotFound) {
        this.actionIfNotFound = actionIfNotFound;
    }

    public void setOutputEprAttributeName(String outputEprAttributeName) {
        this.outputEprAttributeName = outputEprAttributeName;
    }

    public String getOutputEprAttributeName() {
        return this.outputEprAttributeName;
    }
}

