/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope.edm;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import com.googlecode.sarasvati.mem.MemGraphProcess;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class TransformEDMRecordsNotificationHandler
extends AbstractWorkflowLauncherNotificationHandler {
    private static final Log log = LogFactory.getLog(TransformEDMRecordsNotificationHandler.class);
    private static final String STATUS_VALUE = "TAGGED";
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    protected MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        log.info((Object)(((Object)((Object)this)).getClass() + " notified. ID subscription: " + subscrId));
        if (!this.mustStart(topic, profile, rsId)) {
            return;
        }
        MemGraphProcess process = new MemGraphProcess(this.getGraph());
        this.getProcessRegistry().associateProcessWithResource((GraphProcess)process, rsId);
        Env env = process.getEnv();
        env.setAttribute("enableableName", this.getEnableableName());
        log.debug((Object)("Starting workflow process for " + this.getEnableableName()));
        try {
            this.prepareProcess((GraphProcess)process, env, rsId, profile);
        }
        catch (RuntimeException e) {
            env.setAttribute("hasFailed", (Object)true);
            env.setAttribute("errorMessage", e.getMessage());
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            env.setAttribute("errorDetails", stackTrace.toString());
            throw e;
        }
        this.getEngine().startProcess((GraphProcess)process);
    }

    private boolean mustStart(String topic, String profile, String rsId) {
        String topicPrefix = this.getTopicPrefix();
        if (!topic.startsWith(topicPrefix)) {
            log.debug((Object)("WF must not start because of missing topic prefix: " + topicPrefix));
            return false;
        }
        String xQueryStatus = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//LAST_UPDATE_STATUS/text()";
        try {
            String statusValue = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xQueryStatus).get(0);
            if (statusValue.equals(STATUS_VALUE)) {
                return true;
            }
            log.debug((Object)("WF must not start because status value is : " + statusValue));
            return false;
        }
        catch (ISLookUpException e) {
            log.debug((Object)("WF must not start because of lookup exception: " + (Object)((Object)e)));
            return false;
        }
    }

    protected void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
        log.debug((Object)("NotificationHandler to transform Hope records into EDM records. rsId (TDS id) = " + rsId));
        String datasource = "";
        String datasink = "";
        String repId = "";
        String xsltCode = "";
        String sourceQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//DATA_SOURCE/text()";
        String sinkQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//DATA_SINK/text()";
        String repQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//REPOSITORY_SERVICE_IDENTIFIER/text()";
        String xsltQuery = "let $ruleID := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//TRANSFORMATION_RULE_DS_IDENTIFIER/text() " + "return //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $ruleID]//SCRIPT/CODE/*[local-name()='stylesheet']";
        try {
            datasource = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(sourceQuery);
            datasink = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(sinkQuery);
            repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(repQuery);
            xsltCode = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xsltQuery).get(0);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ISLookUpException e) {
            throw new RuntimeException(e);
        }
        String dataSinkId = this.sourceDescriptionGenerator.getParameters(datasink).getId();
        String dataSourceId = this.sourceDescriptionGenerator.getParameters(datasource).getId();
        env.setAttribute("mdstoreSrc", dataSourceId);
        env.setAttribute("mdstoreSink", dataSinkId);
        env.setAttribute("dataDsId", dataSinkId);
        env.setAttribute("repositoryId", repId);
        env.setAttribute("xsltCode", xsltCode);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

