/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class AssignTDSRule
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(AssignTDSRule.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<ISRegistryService> registryLocator;
    private String actionIfNotFound = "failed";

    public void execute(Engine engine, NodeToken token) {
        Env env = token.getFullEnv();
        String tdsId = env.getAttribute("dataDsId");
        log.info((Object)("******TDS ID: " + tdsId));
        String tdsMdFormatsQuery = "let $tds := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + tdsId + "'] return concat($tds//SOURCE_METADATA_FORMAT/@name,':-:', $tds//SINK_METADATA_FORMAT/@name) ";
        try {
            String tdsMdFormats = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(tdsMdFormatsQuery).get(0);
            String srcMdFormat = tdsMdFormats.split(":-:")[0];
            String sinkMdFormat = tdsMdFormats.split(":-:")[1];
            String updateRule = "let $tdsRuleID := //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationRuleDSResourceType' and  .//SOURCE_METADATA_FORMAT/@name='" + srcMdFormat + "' and .//SINK_METADATA_FORMAT/@name='" + sinkMdFormat + "']//RESOURCE_IDENTIFIER/@value/string() return update value //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + tdsId + "']//TRANSFORMATION_RULE_DS_IDENTIFIER with $tdsRuleID";
            boolean res = ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(updateRule);
            if (!res) {
                engine.complete(token, this.actionIfNotFound);
            } else {
                engine.complete(token, Arc.DEFAULT_ARC);
            }
        }
        catch (ISLookUpException e) {
            if (this.actionIfNotFound.equals("failed")) {
                token.getEnv().setAttribute("hasFailed", (Object)true);
                token.getEnv().setAttribute("errorMessage", "cannot assign rule for TDS " + tdsId + ": " + (Object)((Object)e));
                log.warn((Object)"cannot find rule for TDS", (Throwable)e);
            }
            engine.complete(token, this.actionIfNotFound);
        }
        catch (ISRegistryException e) {
            if (this.actionIfNotFound.equals("failed")) {
                token.getEnv().setAttribute("hasFailed", (Object)true);
                token.getEnv().setAttribute("errorMessage", "cannot assign rule for TDS " + tdsId + ": " + (Object)((Object)e));
                log.warn((Object)"cannot find rule for TDS", (Throwable)e);
            }
            engine.complete(token, this.actionIfNotFound);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public String getActionIfNotFound() {
        return this.actionIfNotFound;
    }

    public void setActionIfNotFound(String actionIfNotFound) {
        this.actionIfNotFound = actionIfNotFound;
    }
}

