/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FindTDSByMdFormats
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(FindTDSByMdFormats.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String actionIfNotFound = "failed";
    private String inputMdFormatAttrName;
    private String outputMdFormatAttrName;

    public void execute(Engine engine, NodeToken token) {
        String repId = token.getFullEnv().getAttribute("repositoryId");
        String inputMdFormat = token.getFullEnv().getAttribute(this.inputMdFormatAttrName);
        String outputMdFormat = token.getFullEnv().getAttribute(this.outputMdFormatAttrName);
        log.info((Object)("FINDING TDS for repo " + repId + " inputMdFormat: " + inputMdFormat + " outputMdFormat: " + outputMdFormat));
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationDSResourceType' and .//REPOSITORY_SERVICE_IDENTIFIER = '" + repId + "' and  .//SOURCE_METADATA_FORMAT/@name='" + inputMdFormat + "' and .//SINK_METADATA_FORMAT/@name='" + outputMdFormat + "']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            String tdsId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            token.getEnv().setAttribute("dataDsId", tdsId);
            token.getEnv().setAttribute("tdsId", tdsId);
            String dataSourceId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + tdsId + "']//DATA_SOURCE/string()");
            String dataSinkId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + tdsId + "']//DATA_SINK/string()");
            token.getEnv().setAttribute("dataSource", dataSourceId);
            token.getEnv().setAttribute("dataSink", dataSinkId);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISLookUpException e) {
            if (this.actionIfNotFound.equals("failed")) {
                token.getEnv().setAttribute("hasFailed", (Object)true);
                token.getEnv().setAttribute("errorMessage", "cannot find TDS for repo " + repId + ": " + (Object)((Object)e));
                log.warn((Object)"cannot find TDS for repository", (Throwable)e);
            }
            engine.complete(token, this.actionIfNotFound);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getActionIfNotFound() {
        return this.actionIfNotFound;
    }

    public void setActionIfNotFound(String actionIfNotFound) {
        this.actionIfNotFound = actionIfNotFound;
    }

    public String getInputMdFormatAttrName() {
        return this.inputMdFormatAttrName;
    }

    public void setInputMdFormatAttrName(String inputMdFormatAttrName) {
        this.inputMdFormatAttrName = inputMdFormatAttrName;
    }

    public String getOutputMdFormatAttrName() {
        return this.outputMdFormatAttrName;
    }

    public void setOutputMdFormatAttrName(String outputMdFormatAttrName) {
        this.outputMdFormatAttrName = outputMdFormatAttrName;
    }
}

