/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class StoreCleanedHopeRecords
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private DataSinkResolver dataSinkResolver;
    private WorkflowCountingResultSetFactory countingRSFactory;
    private String outputFormat;
    private String outputInterpretation;

    public void execute(Engine engine, NodeToken token) {
        try {
            String dataSource = token.getFullEnv().getAttribute("dataSource");
            String xquery = "for $x in collection('/db/DRIVER/TransformationDSResources/TransformationDSResourceType') where $x//SINK_METADATA_FORMAT/@interpretation = '" + this.outputInterpretation + "' and " + "$x//DATA_SOURCE='" + dataSource + "' " + "return concat($x//RESOURCE_IDENTIFIER/@value,'|-!-|',$x//DATA_SINK/text())";
            String s = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xquery);
            String[] arr = s.split("\\|-!-\\|");
            token.getEnv().setAttribute("dataDsId", arr[0]);
            String dataSink = arr[1];
            W3CEndpointReference cleanedEpr = (W3CEndpointReference)token.getEnv().getTransientAttribute("cleaned_epr");
            this.dataSinkResolver.resolve(dataSink).store(this.countingRSFactory.createCountingResultSet(cleanedEpr, token));
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    @Required
    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputInterpretation() {
        return this.outputInterpretation;
    }

    public void setOutputInterpretation(String outputInterpretation) {
        this.outputInterpretation = outputInterpretation;
    }

    public WorkflowCountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }
}

