/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope.groovy;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.is.sn.EPRUtil;
import eu.dnetlib.enabling.manager.msro.hope.groovy.DNetGroovyEnabler;
import eu.dnetlib.enabling.manager.msro.hope.groovy.DefaultDNetGroovyEnablerFactory;
import eu.dnetlib.enabling.manager.msro.hope.groovy.RunnableGroovy;
import eu.dnetlib.enabling.resultset.ResultSetRegistry;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.push.PushResultSet;
import eu.dnetlib.enabling.resultset.push.PushResultSetFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import groovy.lang.GroovyShell;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroovyScriptNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(GroovyScriptNode.class);
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource
    private PushResultSetFactory pushResultSetFactory;
    @Resource
    private DefaultDNetGroovyEnablerFactory groovyEnablerFactory;
    @Resource
    private ResultSetRegistry rsRegistry;
    @Resource
    private DataSourceResolver dataSourceResolver;
    private String outputEprAttributeName = "epr_output";
    private List<String> defaultGroovyClassPath = Lists.newArrayList((Object[])new String[]{"/var/lib/hope-scripts", "/var/lib/hope-scripts/eu"});

    private void loadNeededScripts(GroovyScriptEngine gse) throws ResourceException, ScriptException {
        gse.loadScriptByName("eu/dnetlib/hope/domains/common/DerivedResource.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/common/OAIHeader.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/archive/EADFields.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/archive/EADTemplateRoots.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/visual/LidoObject.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/library/MarcFields.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/library/MarcTemplateRoots.groovy");
        gse.loadScriptByName("eu/dnetlib/hope/domains/generic/DublinCoreObject.groovy");
    }

    public void execute(Engine engine, NodeToken token) {
        Env env = token.getEnv();
        try {
            String mainClassName = token.getFullEnv().getAttribute("dnetGroovyClassName");
            String groovyClassPath = token.getFullEnv().getAttribute("groovyClassPath");
            if (groovyClassPath == null) {
                this.failed(engine, token, new RuntimeException("Null groovy classpath is not allowed!"));
            } else {
                if (!this.defaultGroovyClassPath.contains(groovyClassPath)) {
                    this.defaultGroovyClassPath.add(groovyClassPath);
                }
                String dataSource = env.getAttribute("dataSource");
                String repositoryId = token.getFullEnv().getAttribute("repositoryId");
                log.debug((Object)("datasource to resolve: " + dataSource));
                log.debug((Object)("repositoryId: " + repositoryId));
                W3CEndpointReference epr_input = this.dataSourceResolver.resolve(dataSource).retrieve();
                if (mainClassName != null && groovyClassPath != null) {
                    log.info((Object)"groovy classpath");
                    for (String root : this.defaultGroovyClassPath) {
                        log.info((Object)root);
                    }
                    W3CEndpointReference epr_out = this.pushResultSetFactory.createPushResultSet(12000);
                    PushResultSet prs = (PushResultSet)this.rsRegistry.getResultSetById(EPRUtil.getResourceIdentifier((W3CEndpointReference)epr_out));
                    GroovyScriptEngine gse = new GroovyScriptEngine(this.defaultGroovyClassPath.toArray(new String[0]));
                    this.loadNeededScripts(gse);
                    gse.getGroovyClassLoader().loadClass(mainClassName);
                    log.debug((Object)"Loaded classes:");
                    for (Class c : gse.getGroovyClassLoader().getLoadedClasses()) {
                        log.debug((Object)c.getCanonicalName());
                    }
                    log.debug((Object)"***********************************************");
                    GroovyShell groovyShell = new GroovyShell((ClassLoader)gse.getGroovyClassLoader());
                    RunnableGroovy groovyInstance = (RunnableGroovy)groovyShell.evaluate("new " + mainClassName + "()");
                    DNetGroovyEnabler groovyEnabler = this.groovyEnablerFactory.getDnetGroovyEnabler();
                    groovyEnabler.setInputEPR(epr_input);
                    groovyEnabler.setPushResultSet(prs);
                    groovyEnabler.setResultSetClientFactory(this.resultSetClientFactory);
                    groovyEnabler.setRunnableGroovy(groovyInstance);
                    groovyEnabler.setRepoId(repositoryId);
                    Thread t = new Thread(groovyEnabler);
                    t.start();
                    token.getEnv().setAttribute(this.outputEprAttributeName + "_s", epr_out.toString());
                    token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)epr_out);
                } else {
                    log.debug((Object)"Groovy transformation not requested, the input epr will be just passed as output epr");
                    token.getEnv().setAttribute(this.outputEprAttributeName + "_s", epr_input.toString());
                    token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)epr_input);
                }
            }
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public PushResultSetFactory getPushResultSetFactory() {
        return this.pushResultSetFactory;
    }

    public void setPushResultSetFactory(PushResultSetFactory pushResultSetFactory) {
        this.pushResultSetFactory = pushResultSetFactory;
    }

    public ResultSetRegistry getRsRegistry() {
        return this.rsRegistry;
    }

    public void setRsRegistry(ResultSetRegistry rsRegistry) {
        this.rsRegistry = rsRegistry;
    }

    public String getOutputEprAttributeName() {
        return this.outputEprAttributeName;
    }

    public void setOutputEprAttributeName(String outputEprAttributeName) {
        this.outputEprAttributeName = outputEprAttributeName;
    }

    public DefaultDNetGroovyEnablerFactory getGroovyEnablerFactory() {
        return this.groovyEnablerFactory;
    }

    public void setGroovyEnablerFactory(DefaultDNetGroovyEnablerFactory groovyEnablerFactory) {
        this.groovyEnablerFactory = groovyEnablerFactory;
    }

    public List<String> getDefaultGroovyClassPath() {
        return this.defaultGroovyClassPath;
    }

    public void setDefaultGroovyClassPath(List<String> defaultGroovyClassPath) {
        this.defaultGroovyClassPath = defaultGroovyClassPath;
    }
}

