package eu.dnetlib.enabling.manager.msro.hadoop;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

import com.mongodb.hadoop.MongoOutputFormat;
import com.mongodb.hadoop.util.MongoConfigUtil;

public class MDStoreOutputFormat extends MongoOutputFormat<Text, Text> {

	/**
	 * Get the record writer that points to the output collection. TODO: check what can be passed in context. See
	 * MDStoreRecordWriter in current package and MongoRecordWriter in mongo-hadoop project.
	 */
	@Override
	public RecordWriter<Text, Text> getRecordWriter(final TaskAttemptContext context) {
		return new MDStoreRecordWriter(MongoConfigUtil.getOutputCollection(context.getConfiguration()), context);
	}
}
