package eu.dnetlib.enabling.manager.msro.hadoop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ToolRunner;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Assigns to a TDS the TransformationRuleDSREsource matching source and sink metadata format of the TDS.
 * 
 * @author alessia
 * 
 */
public class MapReduceWithXSLTStarterJob extends AbstractJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(MapReduceWithXSLTStarterJob.class);

	private String actionIfNotFound = "failed";
	private String mdstoreName = "mdstore";
	private String mongoHostName = "localhost";

	@Override
	public void execute(Engine engine, NodeToken token) {
		Env env = token.getFullEnv();
		String mdstoreSrc = env.getAttribute("mdstoreSrc");
		String mdstoreSink = env.getAttribute("mdstoreSink");
		String repoId = token.getFullEnv().getAttribute("repositoryId");
		String xsltCode = env.getAttribute("xsltCode");

		log.info("env attributes:");
		log.info(mdstoreSrc + "\n" + mdstoreSink + "\n" + repoId);
		try {
			ToolRunner.run(new Configuration(), new HopeEDMTransformer(), new String[] { mdstoreName, mdstoreSrc, mdstoreSink, repoId, xsltCode,
					mongoHostName });
			engine.complete(token, Arc.DEFAULT_ARC);
		} catch (Exception e1) {
			token.getEnv().setAttribute("hasFailed", true);
			token.getEnv().setAttribute("errorMessage", "Cannot run map reduce job: " + e1);
			log.warn("Cannot run map reduce job", e1);
			engine.complete(token, this.actionIfNotFound);
		}
	}

	public String getActionIfNotFound() {
		return actionIfNotFound;
	}

	public void setActionIfNotFound(String actionIfNotFound) {
		this.actionIfNotFound = actionIfNotFound;
	}

	public String getMdstoreName() {
		return mdstoreName;
	}

	public void setMdstoreName(String mdstoreName) {
		this.mdstoreName = mdstoreName;
	}

	public String getMongoHostName() {
		return mongoHostName;
	}

	public void setMongoHostName(String mongoHostName) {
		this.mongoHostName = mongoHostName;
	}

}
