package eu.dnetlib.enabling.manager.msro.hadoop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ToolRunner;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.workflow.AbstractJobNode;

/**
 * 
 * @author alessia
 * 
 */
public class MergeTagsStarterJob extends AbstractJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(MergeTagsStarterJob.class);

	private String actionIfNotFound = "failed";
	private String mdstoreName = "mdstore";
	private String mdstoreSrc = "mdstoreSrc";
	private String mdstoreSink = "mdstoreSink";
	private String mongoHostName = "localhost";

	@Override
	public void execute(Engine engine, NodeToken token) {
		Env env = token.getFullEnv();
		String mdstoreSrcName = env.getAttribute(mdstoreSrc);
		String mdstoreSinkName = env.getAttribute(mdstoreSink);
		if (mdstoreSinkName == null || mdstoreSinkName.isEmpty())
			mdstoreSinkName = mdstoreSink;
		log.info("mdstores involved in m/r for tags:");
		log.info(mdstoreSrcName + " - " + mdstoreSinkName);
		try {
			ToolRunner.run(new Configuration(), new HopeTagTransformer(), new String[] { mdstoreName, mdstoreSrcName, mdstoreSinkName, mongoHostName });
			engine.complete(token, Arc.DEFAULT_ARC);
		} catch (Exception e1) {
			token.getEnv().setAttribute("hasFailed", true);
			token.getEnv().setAttribute("errorMessage", "Cannot run map reduce job: " + e1);
			log.warn("Cannot run map reduce job", e1);
			engine.complete(token, this.actionIfNotFound);
		}
	}

	public String getActionIfNotFound() {
		return actionIfNotFound;
	}

	public void setActionIfNotFound(String actionIfNotFound) {
		this.actionIfNotFound = actionIfNotFound;
	}

	public String getMdstoreName() {
		return mdstoreName;
	}

	public void setMdstoreName(String mdstoreName) {
		this.mdstoreName = mdstoreName;
	}

	public String getMdstoreSrc() {
		return mdstoreSrc;
	}

	public void setMdstoreSrc(String mdstoreSrc) {
		this.mdstoreSrc = mdstoreSrc;
	}

	public String getMdstoreSink() {
		return mdstoreSink;
	}

	public void setMdstoreSink(String mdstoreSink) {
		this.mdstoreSink = mdstoreSink;
	}

	public String getMongoHostName() {
		return mongoHostName;
	}

	public void setMongoHostName(String mongoHostName) {
		this.mongoHostName = mongoHostName;
	}

}
