package eu.dnetlib.enabling.manager.msro.hope;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import com.googlecode.sarasvati.mem.MemGraphProcess;

import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * This is a new reindex notification handler which reacts on modification of the TDS.
 * 
 * TODO: This is a copy of the AbstractReindexEFGNotificationHandler. When the latter is merged into the main reindex
 * this has to be removved and subclasses should subclass the new class in msro
 * 
 * @author marko
 * 
 */
public abstract class AbstractReindexHopeNotificationHandler extends AbstractWorkflowLauncherNotificationHandler {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(AbstractReindexHopeNotificationHandler.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;
	private ServiceLocator<ISLookUpService> lookupLocator;

	private String layout;

	/**
	 * Gets the mdstore identifier to index.
	 * 
	 * @param rsId
	 *            identifier of the profile relative to the notifaction (i.e., the TDS from hope to EDM)
	 * @param profile
	 *            the profile relative to the notifaction (i.e., the TDS from hope to EDM)
	 * 
	 * @throws ISLookUpException
	 * @throws ISLookUpDocumentNotFoundException
	 */
	protected abstract String obtainMdId(final String rsId, final String profile) throws ISLookUpDocumentNotFoundException, ISLookUpException;

	protected abstract boolean mustStart(String topic, String profile, String rsId);

	/**
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.tools.blackboard.NotificationHandler#notified(java.lang.String, java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	@Override
	public void notified(final String subscrId, final String topic, final String rsId, final String profile) {
		log.debug(this.getClass() + " notified. ID subscription: " + subscrId);
		if (!this.mustStart(topic, profile, rsId))
			return;

		final GraphProcess process = new MemGraphProcess(this.getGraph());
		this.getProcessRegistry().associateProcessWithResource(process, rsId);

		Env env = process.getEnv();
		env.setAttribute("enableableName", getEnableableName());

		log.debug("Starting workflow process for " + getEnableableName());

		try {
			prepareProcess(process, env, rsId, profile);
		} catch (RuntimeException e) {
			env.setAttribute("hasFailed", true);
			env.setAttribute("errorMessage", e.getMessage());
			final StringWriter stackTrace = new StringWriter();
			e.printStackTrace(new PrintWriter(stackTrace));

			env.setAttribute("errorDetails", stackTrace.toString());
			throw e;
		}

		this.getEngine().startProcess(process);
	}

	@Override
	public void prepareProcess(final GraphProcess process, final Env env, final String rsId, final String profile) {

		log.debug("rsId: " + rsId);
		log.debug("profile: " + profile);
		try {
			final String mdId = this.obtainMdId(rsId, profile);

			this.getProcessRegistry().associateProcessWithResource(process, mdId);

			final String query = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + mdId + "' or contains(.//DATA_SINK, '" + mdId + "')]"
					+ "//REPOSITORY_SERVICE_IDENTIFIER/text()";

			final String repId = this.lookupLocator.getService().getResourceProfileByQuery(query);
			this.getProcessRegistry().associateProcessWithResource(process, repId);
			env.setAttribute("repoId", repId);

			final String combinedQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']//METADATA_FORMAT/text(),"
					+ "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']//METADATA_FORMAT_INTERPRETATION/text()";

			List<String> combined = this.lookupLocator.getService().quickSearchProfile(combinedQuery);

			env.setAttribute("dataSource", this.getSourceDescriptionGenerator().generateDataSourceDescriptor(mdId));
			env.setAttribute("mdId", mdId);
			env.setAttribute("format", combined.get(0));
			env.setAttribute("interpretation", combined.get(1));
			env.setAttribute("layout", this.getLayout());
			env.setAttribute("profileTDS", profile);

		} catch (final ISLookUpDocumentNotFoundException e) {
			throw new IllegalStateException("cannot re-index", e);
		} catch (final ISLookUpException e) {
			throw new IllegalStateException("cannot re-index", e);
		}

	}

	@Required
	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getLayout() {
		return this.layout;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return this.lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public void setSourceDescriptionGenerator(final MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
		this.sourceDescriptionGenerator = sourceDescriptionGenerator;
	}

	public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
		return this.sourceDescriptionGenerator;
	}

}
