package eu.dnetlib.enabling.manager.msro.hope;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Assigns to a TDS the TransformationRuleDSREsource matching source and sink metadata format of the TDS.
 * @author alessia
 *
 */
public class AssignTDSRule extends AbstractJobNode{

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(AssignTDSRule.class);

	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;
	
	private ServiceLocator<ISRegistryService> registryLocator;
	
	private String actionIfNotFound = "failed";
	
	@Override
	public void execute(Engine engine, NodeToken token) {
		final Env env = token.getFullEnv();
		final String tdsId = env.getAttribute("dataDsId");
		log.info("******TDS ID: "+tdsId);
		//find source and sink mdformat of the target TDS
		String tdsMdFormatsQuery = "let $tds := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '"+tdsId+"'] return concat($tds//SOURCE_METADATA_FORMAT/@name,':-:', $tds//SINK_METADATA_FORMAT/@name) ";
		try {
			String tdsMdFormats = this.lookupLocator.getService().quickSearchProfile(tdsMdFormatsQuery).get(0);
			String srcMdFormat = tdsMdFormats.split(":-:")[0];
			String sinkMdFormat = tdsMdFormats.split(":-:")[1];
			//find TDSRule with the  retrieved mdFormat
			String updateRule = "let $tdsRuleID := //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationRuleDSResourceType' and  .//SOURCE_METADATA_FORMAT/@name='" + srcMdFormat + "' and .//SINK_METADATA_FORMAT/@name='" + sinkMdFormat
				+ "']//RESOURCE_IDENTIFIER/@value/string() return update value //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '"+tdsId+"']//TRANSFORMATION_RULE_DS_IDENTIFIER with $tdsRuleID";
			boolean res = this.registryLocator.getService().executeXUpdate(updateRule);
			if(!res){
				engine.complete(token, actionIfNotFound);
			}
			else{
				engine.complete(token, Arc.DEFAULT_ARC);
			}
		} catch (ISLookUpException e) {
			if (this.actionIfNotFound.equals("failed")) {
				token.getEnv().setAttribute("hasFailed", true);
				token.getEnv().setAttribute("errorMessage", "cannot assign rule for TDS "+tdsId+": " + e);
				log.warn("cannot find rule for TDS", e);
			}
			engine.complete(token, this.actionIfNotFound);
		} catch (ISRegistryException e) {
			if (this.actionIfNotFound.equals("failed")) {
				token.getEnv().setAttribute("hasFailed", true);
				token.getEnv().setAttribute("errorMessage", "cannot assign rule for TDS "+tdsId+": " + e);
				log.warn("cannot find rule for TDS", e);
			}
			engine.complete(token, this.actionIfNotFound);
		}

	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}
	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}
	@Required
	public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

	public String getActionIfNotFound() {
		return actionIfNotFound;
	}

	public void setActionIfNotFound(String actionIfNotFound) {
		this.actionIfNotFound = actionIfNotFound;
	}
	
	
}
