package eu.dnetlib.enabling.manager.msro.hope;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * This is an AbstractJobNode extension that applies the cleaning rules to a given datasource.
 * 
 * @author alessia
 * 
 */
public class CleanHopeRecords extends AbstractJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(CleanHopeRecords.class);

	/**
	 * service resolver.
	 */
	private ServiceResolver serviceResolver;

	/**
	 * cleaner locator.
	 */
	private ServiceLocator<CleanerService> cleanerLocator;

	/**
	 * The cleaning rule.
	 */
	private String cleaningRule;

	/**
	 * Used to take the resultset EPR from a data source.
	 */
	private DataSourceResolver dataSourceResolver;

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		log.info("cleaning hope records");
		try {

			final String dataSource = token.getFullEnv().getAttribute("dataSource");
			final W3CEndpointReference nativeEpr = this.dataSourceResolver.resolve(dataSource).retrieve();
			/*
			 * TODO: set the context (third arg) to the identifier (PID or name, depending on what we choose to adopt)
			 * of the content provider who own the data in the native epr. CP info should be set in the extra fields of
			 * the repository profile. --> how to get the repository profile from the epr of the hope final mdstore?
			 */
			final W3CEndpointReference cleanedEpr = this.cleanerLocator.getService().cleanInContext(nativeEpr, this.cleaningRule, null);

			final Env env = token.getEnv();

			env.setAttribute("native_epr_string", nativeEpr.toString());
			env.setAttribute("cleaned_epr_string", cleanedEpr.toString());
			env.setTransientAttribute("native_epr", nativeEpr);
			env.setTransientAttribute("cleaned_epr", cleanedEpr);

			log.warn("cleaned epr " + cleanedEpr.toString());

		} catch (final Throwable e) {
			this.failed(engine, token, e);
		}

		super.execute(engine, token);
	}

	public ServiceResolver getServiceResolver() {
		return this.serviceResolver;
	}

	@Required
	public void setServiceResolver(final ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

	public ServiceLocator<CleanerService> getCleanerLocator() {
		return this.cleanerLocator;
	}

	@Required
	public void setCleanerLocator(final ServiceLocator<CleanerService> cleanerLocator) {
		this.cleanerLocator = cleanerLocator;
	}

	public String getCleaningRule() {
		return this.cleaningRule;
	}

	@Required
	public void setCleaningRule(final String cleaningRule) {
		this.cleaningRule = cleaningRule;
	}

	public DataSourceResolver getDataSourceResolver() {
		return this.dataSourceResolver;
	}

	@Required
	public void setDataSourceResolver(final DataSourceResolver dataSourceResolver) {
		this.dataSourceResolver = dataSourceResolver;
	}

}
