package eu.dnetlib.enabling.manager.msro.hope;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Finds the value of an extra field in a repository profile.
 * <p>
 * This class gets the RepositoryProfile whose identifier is the value of the env attribute 'repositoryId'. It puts in
 * the env an attribute such that: the attr key is the value of 'envTargetAttributeName', the attr value is the value of
 * the extra field having the value of 'extraFieldName' as key (or null if no matching extra field is found in the
 * repository profile).
 * </p>
 * 
 * 
 * @author alessia
 * 
 */
public class FindExtraFieldValueJob extends AbstractJobNode {
	/** Logger. */
	private static final Log log = LogFactory.getLog(FindExtraFieldValueJob.class); // NOPMD by marko on 11/24/08 5:02 PM
	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;
	/** Target env attribute name. */
	private String envTargetAttributeName;
	/** Key for the profile's extra field to match. */
	private String extraFieldName;

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		final Env env = token.getFullEnv();
		final String repoId = env.getAttribute("repositoryId");
		String extraFieldValue = null;
		try {
			List<String> values = this.lookupLocator.getService().quickSearchProfile(
					"/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value ='" + repoId + "']//EXTRA_FIELDS/FIELD[./key/string() = '" + this.extraFieldName
							+ "']/value/string()");
			if (!values.isEmpty())
				extraFieldValue = values.get(0);
			log.debug(this.extraFieldName + " = " + extraFieldValue);
			//why did I check for not null values: the job that needs that repository field is in charge of handling also null values!
			//if (extraFieldValue != null && !extraFieldValue.isEmpty()) {
			env.setAttribute(this.envTargetAttributeName, extraFieldValue);
			engine.complete(token, Arc.DEFAULT_ARC);
			//} else
			//	this.failed(engine, token,
			//	new RuntimeException("Missing extra field " + this.envTargetAttributeName + " in repository profile " + repoId));
		} catch (final Exception e) {
			this.failed(engine, token, e);
		}
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return this.lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public String getEnvTargetAttributeName() {
		return this.envTargetAttributeName;
	}

	public void setEnvTargetAttributeName(final String envTargetAttributeName) {
		this.envTargetAttributeName = envTargetAttributeName;
	}

	public String getExtraFieldName() {
		return this.extraFieldName;
	}

	public void setExtraFieldName(final String extraFieldName) {
		this.extraFieldName = extraFieldName;
	}

}
