package eu.dnetlib.enabling.manager.msro.hope;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Merges 2 MDStores. Data from the source mdstores are moved to the sink mdstore. Records in the sink having the same
 * identifiers of those in the source are overwritten. TODO: this class is copied from the efg workflow module. If it is
 * not changed, then it woths to be put in a common package.
 * 
 * @author alessia
 * 
 */
public class MergeMDStoresJob extends AbstractJobNode {

	private static final Log log = LogFactory.getLog(MergeMDStoresJob.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Used to take the resultset EPR from a data source.
	 */
	private DataSourceResolver dataSourceResolver;

	/**
	 * Used to increment a data sink with an EPR.
	 */
	private DataSinkResolver dataSinkResolver;

	/**
	 * Counting resultset factory, for progress bar.
	 */
	private WorkflowCountingResultSetFactory countingRSFactory;

	private String dataSourceAttributeName = "dataSource";
	private String targetStoreID = "targetStoreID";

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		try {
			final String dataSource = token.getFullEnv().getAttribute(dataSourceAttributeName);
			final String sinkID = token.getFullEnv().getAttribute(targetStoreID);

			final W3CEndpointReference epr = this.dataSourceResolver.resolve(dataSource).retrieve();
			this.dataSinkResolver.resolve(new MDStoreDataSinkSourceDescriptorGenerator().generateDataSinkDescriptor(sinkID, "INCREMENTAL")).store(
					this.countingRSFactory.createCountingResultSet(epr, token));
		} catch (final Exception e) {
			this.failed(engine, token, e);
		}
		super.execute(engine, token);
	}

	public DataSourceResolver getDataSourceResolver() {
		return this.dataSourceResolver;
	}

	@Required
	public void setDataSourceResolver(final DataSourceResolver dataSourceResolver) {
		this.dataSourceResolver = dataSourceResolver;
	}

	public DataSinkResolver getDataSinkResolver() {
		return this.dataSinkResolver;
	}

	@Required
	public void setDataSinkResolver(final DataSinkResolver dataSinkResolver) {
		this.dataSinkResolver = dataSinkResolver;
	}

	public WorkflowCountingResultSetFactory getCountingRSFactory() {
		return this.countingRSFactory;
	}

	@Required
	public void setCountingRSFactory(final WorkflowCountingResultSetFactory countingRSFactory) {
		this.countingRSFactory = countingRSFactory;
	}

	public String getDataSourceAttributeName() {
		return dataSourceAttributeName;
	}

	public void setDataSourceAttributeName(String dataSourceAttributeName) {
		this.dataSourceAttributeName = dataSourceAttributeName;
	}

	public String getTargetStoreID() {
		return targetStoreID;
	}

	public void setTargetStoreID(String targetStoreID) {
		this.targetStoreID = targetStoreID;
	}

}
