package eu.dnetlib.enabling.manager.msro.hope;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.data.tagstore.TagStoreService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * 
 * @author alessia
 * 
 */
public class MergeTagStoreByRepoJob extends AbstractJobNode {

	/**
	 * Used to take the resultset EPR from a data source.
	 */
	private DataSourceResolver dataSourceResolver;

	/**
	 * Used to increment a data sink with an EPR.
	 */
	private DataSinkResolver dataSinkResolver;
	@Resource
	private ServiceLocator<ISRegistryService> registryLocator;

	/**
	 * Counting resultset factory, for progress bar.
	 */
	private WorkflowCountingResultSetFactory countingRSFactory;
	@Resource
	private TagStoreService tagStoreService;

	private String tagStoreID = "tagStoreID";
	private String targetStoreID = "targetStoreID";

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		try {
			final String sourceID = token.getFullEnv().getAttribute(tagStoreID);
			final String sinkID = token.getFullEnv().getAttribute(targetStoreID);

			String repoId = token.getFullEnv().getAttribute("repositoryId");
			if (repoId == null || repoId.trim().isEmpty())
				repoId = token.getFullEnv().getAttribute("repoId");

			final W3CEndpointReference epr = tagStoreService.deliverByRepository(sourceID, repoId, null, null);

			this.dataSinkResolver.resolve((new MDStoreDataSinkSourceDescriptorGenerator().generateDataSinkDescriptor(sinkID, "INCREMENTAL"))).store(
					this.countingRSFactory.createCountingResultSet(epr, token));

		} catch (final Exception e) {
			this.failed(engine, token, e);
		}
		super.execute(engine, token);
	}

	public DataSourceResolver getDataSourceResolver() {
		return this.dataSourceResolver;
	}

	@Required
	public void setDataSourceResolver(final DataSourceResolver dataSourceResolver) {
		this.dataSourceResolver = dataSourceResolver;
	}

	public DataSinkResolver getDataSinkResolver() {
		return this.dataSinkResolver;
	}

	@Required
	public void setDataSinkResolver(final DataSinkResolver dataSinkResolver) {
		this.dataSinkResolver = dataSinkResolver;
	}

	public WorkflowCountingResultSetFactory getCountingRSFactory() {
		return this.countingRSFactory;
	}

	@Required
	public void setCountingRSFactory(final WorkflowCountingResultSetFactory countingRSFactory) {
		this.countingRSFactory = countingRSFactory;
	}

	public String getTagStoreID() {
		return tagStoreID;
	}

	public void setTagStoreID(String tagStoreID) {
		this.tagStoreID = tagStoreID;
	}

	public String getTargetStoreID() {
		return targetStoreID;
	}

	public void setTargetStoreID(String targetStoreID) {
		this.targetStoreID = targetStoreID;
	}

	public TagStoreService getTagStoreService() {
		return tagStoreService;
	}

	public void setTagStoreService(TagStoreService tagStoreService) {
		this.tagStoreService = tagStoreService;
	}

	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}

	public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

}
