package eu.dnetlib.enabling.manager.msro.hope;

import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * JobNode to prefetch a result set.
 * 
 * @author alessia
 * 
 */
public class PrefetchResultset extends AbstractJobNode {
	/** Default page size. */
	private static final int PAGE_SIZE = 100;
	/** logger. */
	private static final Log log = LogFactory.getLog(PrefetchResultset.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Counting resultset factory, for progress bar.
	 */
	private WorkflowCountingResultSetFactory countingRSFactory;

	/**
	 * service resolver.
	 */
	private ServiceResolver serviceResolver;
	/** Name of the env transient attribute where the value of the epr is kept. */
	private String eprAttribute = "hopeEpr";

	@Override
	public void execute(final Engine engine, final NodeToken token) {

		final W3CEndpointReference originalEseEpr = (W3CEndpointReference) token.getEnv().getTransientAttribute(this.eprAttribute);

		// TODO: check why using countedEseEpr breaks prefetching (yields 0 elements) 
		//		final W3CEndpointReference countedEseEpr = countingRSFactory.createCountingResultSet(originalEseEpr, this);

		try {
			this.fillPush(originalEseEpr);
			super.execute(engine, token);
		} catch (final Exception e) {
			this.failed(engine, token, e);
		}
	}

	private W3CEndpointReference fillPush(final W3CEndpointReference epr) throws ResultSetException {
		final ResultSetService resultSet = this.serviceResolver.getService(ResultSetService.class, epr);
		final String rsId = this.serviceResolver.getResourceIdentifier(epr);

		int total = 0;
		boolean allDone = false;
		int obtained = 0;

		while (true) {
			total = resultSet.getNumberOfElements(rsId);
			allDone = resultSet.getRSStatus(rsId).equals("closed");

			if ((obtained < total) && (allDone)) {
				log.info("prefetching " + (obtained + 1));
				this.prefetchResult(resultSet, rsId, obtained + 1, total + 1);
				break;
			} else if (allDone) {
				break;
			} else {
				log.info("prefetching " + PAGE_SIZE + " elements from " + (obtained + 1));
				this.prefetchResult(resultSet, rsId, obtained + 1, obtained + PAGE_SIZE);
				obtained += PAGE_SIZE;
			}
		}

		return epr;
	}

	protected void prefetchResult(final ResultSetService resultSet, final String rsId, final int fromPosition, final int toPosition)
			throws ResultSetException {
		for (int i = 0; i < 10; i++) {
			try {
				resultSet.getResult(rsId, fromPosition, toPosition, "WAITING");
				return;
			} catch (final SOAPFaultException e) {
				try {
					final String status = resultSet.getRSStatus(rsId);
					log.info("prefetch didn't receive any data, waiting " + i + " seconds. Status: " + status);
					if (!"open".equals("status"))
						return;
					Thread.sleep(1000 * (i * i / 2));
				} catch (final InterruptedException e1) {
					// pass
				}
			}
		}
		log.fatal("prefetch took too long waiting for object packaging service");
		throw new IllegalStateException("prefetch took too long waiting for object packaging service to split");
	}

	public ServiceResolver getServiceResolver() {
		return this.serviceResolver;
	}

	@Required
	public void setServiceResolver(final ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

	public WorkflowCountingResultSetFactory getCountingRSFactory() {
		return this.countingRSFactory;
	}

	@Required
	public void setCountingRSFactory(final WorkflowCountingResultSetFactory countingRSFactory) {
		this.countingRSFactory = countingRSFactory;
	}

	public String getEprAttribute() {
		return this.eprAttribute;
	}

	public void setEprAttribute(final String eprAttribute) {
		this.eprAttribute = eprAttribute;
	}

}
