package eu.dnetlib.enabling.manager.msro.hope;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

public class StoreCleanedHopeRecords extends AbstractJobNode {

	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;
	
	/**
	 * Used to take the resultset EPR from a data source.
	 */
	private DataSinkResolver dataSinkResolver;

	/**
	 * Counting resultset factory, for progress bar.
	 */
	private WorkflowCountingResultSetFactory countingRSFactory;

	/**
	 * data sink (mdstore) format, used for searching for matching TDS.
	 */
	private String outputFormat;

	/**
	 * data sink (mdstore) interpretation, used for searching for matching TDS.
	 */
	private String outputInterpretation;

	@Override
	public void execute(Engine engine, NodeToken token) {
		try {
			final String dataSource = token.getFullEnv().getAttribute("dataSource");

			final String xquery = 
				"for $x in collection('/db/DRIVER/TransformationDSResources/TransformationDSResourceType') " +  
				"where " +
				"$x//SINK_METADATA_FORMAT/@interpretation = '" + outputInterpretation + "' and " +
				"$x//DATA_SOURCE='" + dataSource + "' " +
				"return concat($x//RESOURCE_IDENTIFIER/@value,'|-!-|',$x//DATA_SINK/text())";
			final String s = lookupLocator.getService().getResourceProfileByQuery(xquery);

			String[] arr = s.split("\\|-!-\\|");
			
			token.getEnv().setAttribute("dataDsId", arr[0]);
			final String dataSink = arr[1];
			final W3CEndpointReference cleanedEpr = (W3CEndpointReference) token.getEnv().getTransientAttribute("cleaned_epr");
			dataSinkResolver.resolve(dataSink).store(countingRSFactory.createCountingResultSet(cleanedEpr, token));
			//token.getFullEnv().setAttribute("dsForBackLinks", dataSink);
		} catch (Throwable e) {
			failed(engine, token, e);
		}

		super.execute(engine, token);
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public DataSinkResolver getDataSinkResolver() {
		return dataSinkResolver;
	}

	@Required
	public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
		this.dataSinkResolver = dataSinkResolver;
	}

	public String getOutputFormat() {
		return outputFormat;
	}

	public void setOutputFormat(String outputFormat) {
		this.outputFormat = outputFormat;
	}

	public String getOutputInterpretation() {
		return outputInterpretation;
	}

	public void setOutputInterpretation(String outputInterpretation) {
		this.outputInterpretation = outputInterpretation;
	}

	public WorkflowCountingResultSetFactory getCountingRSFactory() {
		return countingRSFactory;
	}

	public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
		this.countingRSFactory = countingRSFactory;
	}
}
