package eu.dnetlib.enabling.manager.msro.hope;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

public class StoreRecords extends AbstractJobNode {

	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Resource
	private DataSinkResolver dataSinkResolver;

	/**
	 * Counting resultset factory, for progress bar.
	 */
	private WorkflowCountingResultSetFactory countingRSFactory;

	/**
	 * data sink (mdstore) format, used for searching for matching TDS. TODO: actually unused. test if we can remove it
	 */
	private String outputFormat;

	/**
	 * data sink (mdstore) interpretation, used for searching for matching TDS. TODO: actually unused. test if we can
	 * remove it
	 */
	private String outputInterpretation;
	/**
	 * Name of the transient attribute in the env for the records source.
	 */
	private String srcEprName = "hopeEpr";

	@Override
	public void execute(final Engine engine, final NodeToken token) {

		try {
			final String dataSink = token.getFullEnv().getAttribute("dataSink");

			final W3CEndpointReference srcEpr = (W3CEndpointReference) token.getEnv().getTransientAttribute(this.srcEprName);

			//this.dataSinkResolver.resolve(dataSink).store(this.countingRSFactory.createCountingResultSet(srcEpr, token));
			this.dataSinkResolver.resolve(dataSink).store(srcEpr);
		} catch (final Throwable e) {
			this.failed(engine, token, e);
		}

		super.execute(engine, token);
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return this.lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public DataSinkResolver getDataSinkResolver() {
		return this.dataSinkResolver;
	}

	@Required
	public void setDataSinkResolver(final DataSinkResolver dataSinkResolver) {
		this.dataSinkResolver = dataSinkResolver;
	}

	public WorkflowCountingResultSetFactory getCountingRSFactory() {
		return this.countingRSFactory;
	}

	@Required
	public void setCountingRSFactory(final WorkflowCountingResultSetFactory countingRSFactory) {
		this.countingRSFactory = countingRSFactory;
	}

	public String getOutputFormat() {
		return this.outputFormat;
	}

	public void setOutputFormat(final String outputFormat) {
		this.outputFormat = outputFormat;
	}

	public String getOutputInterpretation() {
		return this.outputInterpretation;
	}

	public void setOutputInterpretation(final String outputInterpretation) {
		this.outputInterpretation = outputInterpretation;
	}

	public String getSrcEprName() {
		return this.srcEprName;
	}

	public void setSrcEprName(final String srcEprName) {
		this.srcEprName = srcEprName;
	}

}
