package eu.dnetlib.enabling.manager.msro.hope;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * NotificationHandler for the TransformHopeRecords job.
 * 
 * @author alessia
 * 
 */
public class TagAssignerNotificationHandler extends AbstractWorkflowLauncherNotificationHandler {

	private static final Log log = LogFactory.getLog(TagAssignerNotificationHandler.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	protected MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Override
	protected void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
		log.info("mdstore source id " + rsId);
		env.setAttribute("mdId", rsId);
		env.setAttribute("dataSource", this.sourceDescriptionGenerator.generateDataSourceDescriptor(rsId));

		try {
			final String repoQuery = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + rsId + "' or contains(.//DATA_SINK, '" + rsId
					+ "')]//REPOSITORY_SERVICE_IDENTIFIER/text()";
			final String repId = lookupLocator.getService().getResourceProfileByQuery(repoQuery);
			log.debug("got repository profile " + repId);
			env.setAttribute("repositoryId", repId);
		} catch (final ISLookUpDocumentNotFoundException e) {
			log.warn("cannot locate the repository associated with the mdstore " + rsId, e);
		} catch (final ISLookUpException e) {
			log.warn("cannot locate the repository associated with the mdstore " + rsId, e);
		}
	}

	public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
		return sourceDescriptionGenerator;
	}

	public void setSourceDescriptionGenerator(MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
		this.sourceDescriptionGenerator = sourceDescriptionGenerator;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

}
