package eu.dnetlib.enabling.manager.msro.hope;

import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;

public class TransformRecords extends AbstractJobNode {
	private static final Log log = LogFactory.getLog(TransformRecords.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * xslt mapped resultset factory.
	 */
	private XSLTMappedResultSetFactory xsltRSFactory;

	/**
	 * service resolver.
	 */
	private ServiceResolver serviceResolver;

	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;

	private DataSourceResolver dataSourceResolver;

	private String actionIfNotFound = "failed";

	private String outputEprAttributeName = "transformedEpr";

	@Override
	public void execute(Engine engine, NodeToken token) {
		final Env env = token.getFullEnv();
		final String tdsId = env.getAttribute("tdsId");
		log.fatal("TDS id = " + tdsId);
		final String dataSource = token.getFullEnv().getAttribute("dataSource");
		final String queryCodeRule = "let $ruleID := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + tdsId
				+ "']//BODY/CONFIGURATION/TRANSFORMATION_RULE_DS_IDENTIFIER/string() "
				+ "return //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=$ruleID]/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
		W3CEndpointReference mdStoreRsetEpr = null;
		try {
			mdStoreRsetEpr = this.dataSourceResolver.resolve(dataSource).retrieve();
			String xsltCode = this.lookupLocator.getService().getResourceProfileByQuery(queryCodeRule);
			//handle empty code:
			if (xsltCode == null || xsltCode.isEmpty()) {
				log.fatal("TDS has a rule to apply, but the TransformationRuleDSProfile has no code: no transformation will be applied");
				// input ResultSet EPR is the output ResultSet EPR
				token.getEnv().setAttribute("mdstoreNativeEprString", mdStoreRsetEpr.toString());
				token.getEnv().setTransientAttribute("mdstoreNative", mdStoreRsetEpr);

				token.getEnv().setAttribute(outputEprAttributeName + "String", mdStoreRsetEpr.toString());
				token.getEnv().setTransientAttribute(outputEprAttributeName, mdStoreRsetEpr);
			}
			//final Resource xsltResource = new ByteArrayResource(xsltCode.getBytes());
			log.debug(xsltCode);
			final W3CEndpointReference transformedEpr = this.xsltRSFactory.createMappedResultSet(mdStoreRsetEpr,
					new StreamSource(IOUtils.toInputStream(xsltCode)));

			token.getEnv().setAttribute("mdstoreNativeEprString", mdStoreRsetEpr.toString());
			token.getEnv().setTransientAttribute("mdstoreNative", mdStoreRsetEpr);

			token.getEnv().setAttribute(outputEprAttributeName + "String", transformedEpr.toString());
			token.getEnv().setTransientAttribute(outputEprAttributeName, transformedEpr);

			log.warn("Transformed epr " + transformedEpr.toString());

		} catch (eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException e) {
			//handle no TransformationRuleDS
			if (this.actionIfNotFound.equals("failed")) {
				this.failed(engine, token, e);
			} else {
				log.debug("TransformationRuleDSProfile not found, no transformation will be applied");

				// input ResultSet EPR is the output ResultSet EPR
				token.getEnv().setAttribute("mdstoreNativeEprString", mdStoreRsetEpr.toString());
				token.getEnv().setTransientAttribute("mdstoreNative", mdStoreRsetEpr);

				token.getEnv().setAttribute(outputEprAttributeName + "String", mdStoreRsetEpr.toString());
				token.getEnv().setTransientAttribute(outputEprAttributeName, mdStoreRsetEpr);
			}
		} catch (final Throwable e) {
			this.failed(engine, token, e);
		}

		super.execute(engine, token);
	}

	public XSLTMappedResultSetFactory getXsltRSFactory() {
		return xsltRSFactory;
	}

	@Required
	public void setXsltRSFactory(XSLTMappedResultSetFactory xsltRSFactory) {
		this.xsltRSFactory = xsltRSFactory;
	}

	public ServiceResolver getServiceResolver() {
		return serviceResolver;
	}

	@Required
	public void setServiceResolver(ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public DataSourceResolver getDataSourceResolver() {
		return dataSourceResolver;
	}

	@Required
	public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
		this.dataSourceResolver = dataSourceResolver;
	}

	public String getActionIfNotFound() {
		return actionIfNotFound;
	}

	public void setActionIfNotFound(String actionIfNotFound) {
		this.actionIfNotFound = actionIfNotFound;
	}

	public void setOutputEprAttributeName(String outputEprAttributeName) {
		this.outputEprAttributeName = outputEprAttributeName;
	}

	public String getOutputEprAttributeName() {
		return outputEprAttributeName;
	}

}
