/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.data.tagstore.TagStoreService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class MergeTagStoreByRepoJob
extends AbstractJobNode {
    private DataSourceResolver dataSourceResolver;
    private DataSinkResolver dataSinkResolver;
    @Resource
    private ServiceLocator<ISRegistryService> registryLocator;
    private WorkflowCountingResultSetFactory countingRSFactory;
    @Resource
    private TagStoreService tagStoreService;
    private String tagStoreID = "tagStoreID";
    private String targetStoreID = "targetStoreID";

    public void execute(Engine engine, NodeToken token) {
        try {
            String sourceID = token.getFullEnv().getAttribute(this.tagStoreID);
            String sinkID = token.getFullEnv().getAttribute(this.targetStoreID);
            String repoId = token.getFullEnv().getAttribute("repositoryId");
            if (repoId == null || repoId.trim().isEmpty()) {
                repoId = token.getFullEnv().getAttribute("repoId");
            }
            W3CEndpointReference epr = this.tagStoreService.deliverByRepository(sourceID, repoId, null, null);
            this.dataSinkResolver.resolve(new MDStoreDataSinkSourceDescriptorGenerator().generateDataSinkDescriptor(sinkID, "INCREMENTAL")).store(this.countingRSFactory.createCountingResultSet(epr, token));
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    @Required
    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }

    public WorkflowCountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    @Required
    public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }

    public String getTagStoreID() {
        return this.tagStoreID;
    }

    public void setTagStoreID(String tagStoreID) {
        this.tagStoreID = tagStoreID;
    }

    public String getTargetStoreID() {
        return this.targetStoreID;
    }

    public void setTargetStoreID(String targetStoreID) {
        this.targetStoreID = targetStoreID;
    }

    public TagStoreService getTagStoreService() {
        return this.tagStoreService;
    }

    public void setTagStoreService(TagStoreService tagStoreService) {
        this.tagStoreService = tagStoreService;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

