/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class TransformLocalToDomainNotificationHandler
extends AbstractWorkflowLauncherNotificationHandler {
    private static final Log log = LogFactory.getLog(TransformLocalToDomainNotificationHandler.class);
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
        log.info((Object)("NotificationHandler to transform local records into domain records. rsId (TDS) = " + rsId));
        try {
            String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//REPOSITORY_SERVICE_IDENTIFIER/text()";
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            log.debug((Object)("got repository profile " + repId));
            env.setAttribute("repositoryId", repId);
            String queryGroovyConfig = "let $groovyID := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//BODY/CONFIGURATION/TRANSFORMATION_RULE_DS_IDENTIFIER/string() " + "let $groovyProfileConfig := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=$groovyID]/BODY/CONFIGURATION " + "return concat($groovyProfileConfig/GROOVY_CLASSPATH/text(),':-:', $groovyProfileConfig/GROOVY_DNETCLASS/text())";
            String configs = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(queryGroovyConfig).get(0);
            log.debug((Object)("Groovy configs: " + configs));
            if (!configs.equals(":-:")) {
                log.debug((Object)"Groovy rule found");
                String[] configArray = configs.split(":-:");
                env.setAttribute("groovyClassPath", configArray[0]);
                env.setAttribute("dnetGroovyClassName", configArray[1]);
            } else {
                log.debug((Object)"No groovy rule to apply");
            }
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.warn((Object)("cannot locate the repository associated with the TDS " + rsId), (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.warn((Object)("cannot locate the repository associated with the TDS " + rsId), (Throwable)e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

