/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class StoreRecords
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private DataSinkResolver dataSinkResolver;
    private WorkflowCountingResultSetFactory countingRSFactory;
    private String outputFormat;
    private String outputInterpretation;
    private String srcEprName = "hopeEpr";

    public void execute(Engine engine, NodeToken token) {
        try {
            String dataSink = token.getFullEnv().getAttribute("dataSink");
            W3CEndpointReference srcEpr = (W3CEndpointReference)token.getEnv().getTransientAttribute(this.srcEprName);
            this.dataSinkResolver.resolve(dataSink).store(srcEpr);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    @Required
    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }

    public WorkflowCountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    @Required
    public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputInterpretation() {
        return this.outputInterpretation;
    }

    public void setOutputInterpretation(String outputInterpretation) {
        this.outputInterpretation = outputInterpretation;
    }

    public String getSrcEprName() {
        return this.srcEprName;
    }

    public void setSrcEprName(String srcEprName) {
        this.srcEprName = srcEprName;
    }
}

