/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class TransformHopeRecordsNotificationHandler
extends AbstractWorkflowLauncherNotificationHandler {
    private static final Log log = LogFactory.getLog(TransformHopeRecordsNotificationHandler.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    protected MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;

    protected void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
        log.info((Object)("NotificationHandler to transform domain records into Hope records. rsId (mdStoreID) = " + rsId));
        try {
            String dataSource = this.sourceDescriptionGenerator.generateDataSourceDescriptor(rsId);
            String xquery = "//DATA_SINK[\t../SINK_METADATA_FORMAT/@name='hope' and \t..//DATA_SOURCE = '" + dataSource + "']/text()";
            String dataSink = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xquery);
            String query = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + rsId + "' or contains(.//DATA_SINK, '" + rsId + "')]//REPOSITORY_SERVICE_IDENTIFIER/text()";
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            log.debug((Object)("got repository profile " + repId));
            env.setAttribute("repositoryId", repId);
            env.setAttribute("dataSource", dataSource);
            env.setAttribute("dataSink", dataSink);
            env.setAttribute("outputFormat", "hope");
            String tdsIdQuery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationDSResourceType' and .//DATA_SOURCE = '" + dataSource + "' and .//DATA_SINK = '" + dataSink + "']//RESOURCE_IDENTIFIER/@value/string()";
            String tdsId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(tdsIdQuery);
            env.setAttribute("tdsId", tdsId);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.warn((Object)("cannot locate the repository associated with the mdstore " + rsId), (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.warn((Object)("cannot locate the repository associated with the mdstore " + rsId), (Throwable)e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

