/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope.groovy;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.manager.msro.hope.groovy.DNetGroovyEnabler;
import eu.dnetlib.enabling.manager.msro.hope.groovy.RunnableGroovy;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.push.PushResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DNetGroovyEnablerImpl
implements DNetGroovyEnabler {
    private static final Log log = LogFactory.getLog(DNetGroovyEnablerImpl.class);
    private static String SENTINEL = "END";
    private static String FAIL_SENTINEL = "FAIL";
    private W3CEndpointReference inputEPR;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    private PushResultSet pushResultSet;
    private BlockingQueue<String> resultsQueue = new ArrayBlockingQueue<String>(100);
    private BlockingQueue<String> inputQueue = new ArrayBlockingQueue<String>(100);
    private RunnableGroovy runnableGroovy;
    private String repoId;

    @Override
    public void run() {
        this.runnableGroovy.setResultsQueue(this.resultsQueue);
        this.runnableGroovy.setInputQueue(this.inputQueue);
        this.runnableGroovy.setRepositoryId(this.repoId);
        Thread t = new Thread(this.runnableGroovy);
        log.info((Object)"Now feeding the groovy script with the epr via the input queue..");
        final Iterator inputs = this.resultSetClientFactory.getClient(this.inputEPR).iterator();
        int c = 0;
        try {
            t.start();
            Thread insertor = new Thread(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"Inserting elements in the queue for groovy...");
                    try {
                        while (inputs.hasNext()) {
                            DNetGroovyEnablerImpl.this.inputQueue.put(inputs.next());
                        }
                        DNetGroovyEnablerImpl.this.inputQueue.put(SENTINEL);
                        log.info((Object)"Inserting elements in the queue for groovy... DONE");
                    }
                    catch (InterruptedException ie) {
                        log.fatal((Object)"InterruptedException inserting in the queue for groovy");
                        throw new RuntimeException(ie);
                    }
                }
            });
            insertor.start();
            String res = "";
            log.info((Object)"Reading groovy results from the queue...");
            while (!(res = this.resultsQueue.take()).equals(SENTINEL)) {
                if (res.equals(FAIL_SENTINEL)) {
                    this.pushResultSet.close();
                    throw new RuntimeException("Groovy failure");
                }
                this.pushResultSet.addElements((List)Lists.newArrayList((Object[])new String[]{res}));
                ++c;
            }
            log.info((Object)("pushed " + c + " elements in push RS"));
        }
        catch (InterruptedException e) {
            log.debug((Object)"InterruptedException inserting in / taking from the queue");
            this.pushResultSet.close();
            throw new RuntimeException(e);
        }
        log.debug((Object)("RS before closing it is open: " + this.pushResultSet.isOpen()));
        this.pushResultSet.close();
        log.info((Object)"Results all pushed to the result set");
    }

    @Override
    public void setInputEPR(W3CEndpointReference epr) {
        this.inputEPR = epr;
    }

    @Override
    public void setResultSetClientFactory(ResultSetClientFactory client) {
        this.resultSetClientFactory = client;
    }

    @Override
    public void setPushResultSet(PushResultSet pushRS) {
        this.pushResultSet = pushRS;
    }

    public BlockingQueue<String> getResultsQueue() {
        return this.resultsQueue;
    }

    public void setResultsQueue(BlockingQueue<String> resultsQueue) {
        this.resultsQueue = resultsQueue;
    }

    public W3CEndpointReference getInputEPR() {
        return this.inputEPR;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public PushResultSet getPushResultSet() {
        return this.pushResultSet;
    }

    public RunnableGroovy getRunnableGroovy() {
        return this.runnableGroovy;
    }

    @Override
    public void setRunnableGroovy(RunnableGroovy runnableGroovy) {
        this.runnableGroovy = runnableGroovy;
    }

    public BlockingQueue<String> getInputQueue() {
        return this.inputQueue;
    }

    public void setInputQueue(BlockingQueue<String> inputQueue) {
        this.inputQueue = inputQueue;
    }

    public String getRepoId() {
        return this.repoId;
    }

    @Override
    public void setRepoId(String repoId) {
        this.repoId = repoId;
    }
}

