/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.service;

import com.google.common.collect.Lists;
import eu.dnetlib.pid.service.PIDAssignmentRule;
import eu.dnetlib.pid.service.PIDLocAttRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.socialhistoryservices.pid.LocAttType;
import org.socialhistoryservices.pid.LocationType;
import org.socialhistoryservices.pid.PidType;

public class PIDAssignerHelper {
    private static final Log log = LogFactory.getLog(PIDAssignerHelper.class);
    private String unavailableURL;

    public List<LocationType> getLocationTypeList(PIDAssignmentRule r, Node baseNode) {
        if (!r.hasLocattRules()) {
            log.fatal((Object)("Rule " + r + "with no locattRules. This is unexpected in getLocationTypeList!"));
            return null;
        }
        ArrayList locations = Lists.newArrayList();
        for (String view : r.getLocattRules().keySet()) {
            PIDLocAttRule attRule = r.getLocattRules().get(view);
            if (attRule == null) continue;
            String resolveURLLocatt = "";
            Node resolveURLLocattNode = baseNode.selectSingleNode(attRule.getResolveURLXPath());
            if (!this.isBlank(resolveURLLocattNode)) {
                resolveURLLocatt = resolveURLLocattNode.getText();
            }
            LocationType lt = new LocationType(resolveURLLocatt, view);
            locations.add(lt);
        }
        return locations;
    }

    public boolean isBlank(Node node) {
        return node == null || StringUtils.isBlank((String)node.getText());
    }

    public boolean isNotBlank(Node baseNode, String xPath, String objIdentifier) {
        if (this.isBlank(baseNode.selectSingleNode(xPath))) {
            log.debug((Object)("Record objIdentifier: " + objIdentifier + ". baseNode: " + baseNode.getPath() + " : no node or value at path " + xPath));
            return false;
        }
        return true;
    }

    public String getResolveURL(Node baseNode, String resolveURLXPath) {
        if (StringUtils.isBlank((String)resolveURLXPath)) {
            return "";
        }
        Node resolveURLNode = baseNode.selectSingleNode(resolveURLXPath);
        if (this.isBlank(resolveURLNode)) {
            log.fatal((Object)("Expected resolveURL not found in " + resolveURLXPath + ": using default " + this.getUnavailableURL()));
            return this.getUnavailableURL();
        }
        return resolveURLNode.getText();
    }

    public String getDerivative2URL(List<LocationType> locatts) {
        if (locatts == null) {
            return this.unavailableURL;
        }
        for (LocationType lt : locatts) {
            if (!lt.getView().equals("level2")) continue;
            return lt.getHref();
        }
        return this.unavailableURL;
    }

    public void setEmptyLocatts(PidType pid) {
        LocAttType locatt = new LocAttType();
        locatt.getLocation().addAll(Lists.newArrayList((Object[])new LocationType[]{new LocationType("", "level2"), new LocationType("", "level3")}));
        pid.setLocAtt(locatt);
    }

    public PIDAssignerHelper() {
    }

    public PIDAssignerHelper(String unavailableURL) {
        this();
        this.unavailableURL = unavailableURL;
    }

    public String getUnavailableURL() {
        return this.unavailableURL;
    }

    public void setUnavailableURL(String unavailableURL) {
        this.unavailableURL = unavailableURL;
    }
}

