/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.service;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.socialhistoryservices.pid.CreatePidRequestType;
import org.socialhistoryservices.pid.CreatePidResponseType;
import org.socialhistoryservices.pid.DeletePidRequestType;
import org.socialhistoryservices.pid.DeletePidResponseType;
import org.socialhistoryservices.pid.DeletePidsRequestType;
import org.socialhistoryservices.pid.DeletePidsResponseType;
import org.socialhistoryservices.pid.GetPidByAttributeRequestType;
import org.socialhistoryservices.pid.GetPidByAttributeResponseType;
import org.socialhistoryservices.pid.GetPidRequestType;
import org.socialhistoryservices.pid.GetPidResponseType;
import org.socialhistoryservices.pid.GetQuickPidRequestType;
import org.socialhistoryservices.pid.GetQuickPidResponseType;
import org.socialhistoryservices.pid.LocAttType;
import org.socialhistoryservices.pid.LocationType;
import org.socialhistoryservices.pid.PidResource;
import org.socialhistoryservices.pid.PidType;
import org.socialhistoryservices.pid.UpdatePidRequestType;
import org.socialhistoryservices.pid.UpdatePidResponseType;
import org.socialhistoryservices.pid.UpsertPidRequestType;
import org.socialhistoryservices.pid.UpsertPidResponseType;

public class PidServiceClient {
    private static final Log log = LogFactory.getLog(PidServiceClient.class);
    private PidResource port;

    public PidType createPid(String namingAuthority) {
        CreatePidRequestType requestType = new CreatePidRequestType();
        requestType.setNa(namingAuthority);
        PidType pt = new PidType();
        requestType.setHandle(pt);
        CreatePidResponseType response = this.port.createPid(requestType);
        log.debug((Object)("createPid.result=" + response));
        return response.getHandle();
    }

    public int deletePids(String namingAuthority) {
        DeletePidsRequestType requestType = new DeletePidsRequestType();
        requestType.setNa(namingAuthority);
        DeletePidsResponseType response = this.port.deletePids(requestType);
        log.debug((Object)("deletePids.result=" + response));
        return (int)response.getCount();
    }

    public boolean deletePid(String pid) {
        DeletePidRequestType requestType = new DeletePidRequestType();
        requestType.setPid(pid);
        DeletePidResponseType response = this.port.deletePid(requestType);
        log.debug((Object)("deletePid.result=" + response));
        return response.isDeleted();
    }

    public PidType getPid(String pid) {
        GetPidRequestType requestType = new GetPidRequestType();
        requestType.setPid(pid);
        GetPidResponseType response = this.port.getPid(requestType);
        log.debug((Object)("getPid.result=" + response));
        return response.getHandle();
    }

    public List<PidType> getPidByAttribute(String namingAuthority, String attributeValue) {
        GetPidByAttributeRequestType requestType = new GetPidByAttributeRequestType();
        requestType.setNa(namingAuthority);
        requestType.setAttribute(attributeValue);
        GetPidByAttributeResponseType response = this.port.getPidByAttribute(requestType);
        log.debug((Object)("getPidByAttribute.result=" + response));
        return response.getHandle();
    }

    public PidType getQuickPid(String namingAuthority, String localID, String resolveURL) {
        GetQuickPidRequestType requestType = new GetQuickPidRequestType();
        requestType.setNa(namingAuthority);
        requestType.setLocalIdentifier(localID);
        requestType.setResolveUrl(resolveURL);
        GetQuickPidResponseType response = this.port.getQuickPid(requestType);
        log.debug((Object)("getQuickPid.result=" + response));
        return response.getHandle();
    }

    public PidType update(String pid, String resolveURL, String localID, List<LocationType> locations) {
        PidType pidType = new PidType();
        pidType.setPid(pid);
        pidType.setLocalIdentifier(localID);
        pidType.setResolveUrl(resolveURL);
        LocAttType locs = new LocAttType();
        if (locations != null) {
            locs.getLocation().addAll(locations);
        }
        pidType.setLocAtt(locs);
        return this.updatePid(pidType);
    }

    public PidType updatePid(PidType pid) {
        UpdatePidRequestType requestType = new UpdatePidRequestType();
        requestType.setHandle(pid);
        UpdatePidResponseType response = this.port.updatePid(requestType);
        log.debug((Object)("updatePid.result=" + response));
        return response.getHandle();
    }

    public PidType upsert(String namingAuthority, PidType pid) {
        UpsertPidRequestType requestType = new UpsertPidRequestType();
        requestType.setHandle(pid);
        requestType.setNa(namingAuthority);
        UpsertPidResponseType response = this.port.upsertPid(requestType);
        log.debug((Object)("upsertPid.result=" + response));
        return response.getHandle();
    }

    public PidType upsert(String namingAuthority, String pid, String resolveURL, String localID, List<LocationType> locations) {
        PidType pidType = new PidType();
        pidType.setPid(pid);
        pidType.setLocalIdentifier(localID);
        pidType.setResolveUrl(resolveURL);
        LocAttType locs = new LocAttType();
        if (locations != null) {
            locs.getLocation().addAll(locations);
        }
        pidType.setLocAtt(locs);
        return this.upsert(namingAuthority, pidType);
    }

    public PidResource getPort() {
        return this.port;
    }

    public void setPort(PidResource port) {
        this.port = port;
    }
}

