/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.service;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.cache.EhCache;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.pid.service.CachedPIDUnaryFunction;
import eu.dnetlib.pid.service.PIDAssignmentRule;
import eu.dnetlib.pid.service.PIDLocAttRule;
import eu.dnetlib.pid.service.rmi.PIDAssignerException;
import eu.dnetlib.pid.service.rmi.PIDAssignerService;
import eu.dnetlib.pid.service.rmi.PIDBridgeService;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.socialhistoryservices.pid.PidType;
import org.springframework.beans.factory.annotation.Required;

public class PIDAssignerServiceImpl
extends AbstractBaseService
implements PIDAssignerService {
    private static final Log log = LogFactory.getLog(PIDAssignerServiceImpl.class);
    private MappedResultSetFactory mappedResultSetFactory;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<PIDBridgeService> pidBridgeLocator;
    private EhCache<String, PidType> pidCache = new EhCache();
    private String defaultResolveURL = "";

    @Override
    public W3CEndpointReference assignPIDs(W3CEndpointReference epr, String ruleId, String namingAuthority) throws PIDAssignerException {
        this.pidCache.clear();
        if (ruleId == null || ruleId.isEmpty()) {
            throw new PIDAssignerException("Invalid ruleId: id is empty");
        }
        if (epr == null) {
            throw new PIDAssignerException("Passed epr is empty");
        }
        if (namingAuthority == null || namingAuthority.isEmpty()) {
            throw new PIDAssignerException("Passed naming authority is null or empty");
        }
        Collection<PIDAssignmentRule> rules = this.readRuleProfile(ruleId);
        CachedPIDUnaryFunction function = new CachedPIDUnaryFunction(rules);
        function.setNamingAuthority(namingAuthority);
        function.setPidBridgeService((PIDBridgeService)this.pidBridgeLocator.getService());
        function.setUnavailableURL(this.defaultResolveURL);
        function.setPidCache(this.pidCache);
        return this.mappedResultSetFactory.createMappedResultSet(epr, (UnaryFunction)function);
    }

    private Collection<PIDAssignmentRule> readRuleProfile(String ruleId) throws PIDAssignerException {
        log.info((Object)("Reading PID rule profile id: " + ruleId));
        ArrayList rules = Lists.newArrayList();
        try {
            String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value/string() = '" + ruleId + "']");
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(profile));
            int countRule = 0;
            for (Object o : doc.selectNodes("//RULE")) {
                PIDAssignmentRule currentRule = new PIDAssignmentRule();
                Node node = (Node)o;
                String baseNodes = node.valueOf("./@baseNodes");
                String localID = node.valueOf("./@localID");
                String resolveURL = node.valueOf("./@resolveURL");
                String target = node.valueOf("./@target");
                currentRule.setBaseNodesXPath(baseNodes);
                currentRule.setLocalIDXPath(localID);
                currentRule.setResolveURLXPath(resolveURL);
                currentRule.setTargetXPath(target);
                for (Object locatt : node.selectNodes("./locatt")) {
                    Node locattNode = (Node)locatt;
                    PIDLocAttRule locattRule = new PIDLocAttRule(locattNode.valueOf("./@resolveURL"), locattNode.valueOf("./@target"));
                    currentRule.getLocattRules().put(locattNode.valueOf("./@view"), locattRule);
                }
                log.debug((Object)("Rule number: " + ++countRule + " --> " + currentRule));
                rules.add(currentRule);
            }
            return rules;
        }
        catch (Exception e) {
            throw new PIDAssignerException("Error obtaing rule " + ruleId, e);
        }
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public ServiceLocator<PIDBridgeService> getPidBridgeLocator() {
        return this.pidBridgeLocator;
    }

    @Required
    public void setPidBridgeLocator(ServiceLocator<PIDBridgeService> pidBridgeLocator) {
        this.pidBridgeLocator = pidBridgeLocator;
    }

    @Required
    public void setDefaultResolveURL(String defaultResolveURL) {
        this.defaultResolveURL = defaultResolveURL;
    }

    public String getDefaultResolveURL() {
        return this.defaultResolveURL;
    }

    public EhCache<String, PidType> getPidCache() {
        return this.pidCache;
    }

    public void setPidCache(EhCache<String, PidType> pidCache) {
        this.pidCache = pidCache;
    }
}

