/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.service;

import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.pid.service.PidServiceClient;
import eu.dnetlib.pid.service.rmi.PIDBridgeService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.socialhistoryservices.pid.LocationType;
import org.socialhistoryservices.pid.PidType;

public class PIDBridgeServiceImpl
extends AbstractBaseService
implements PIDBridgeService {
    private static final Log log = LogFactory.getLog(PIDBridgeServiceImpl.class);
    private PidServiceClient pidServiceClient;

    @Override
    public PidType createPid(String namingAuthority) {
        log.debug((Object)("createPid(" + namingAuthority + ")"));
        return this.pidServiceClient.createPid(namingAuthority);
    }

    @Override
    public int deletePids(String namingAuthority) {
        log.debug((Object)("deletePids(" + namingAuthority + ")"));
        return this.pidServiceClient.deletePids(namingAuthority);
    }

    @Override
    public void deleteListPids(List<PidType> pidsToRemove) {
        log.debug((Object)("deletePid(" + pidsToRemove + ")"));
        for (PidType pid : pidsToRemove) {
            this.pidServiceClient.deletePid(pid.getPid());
        }
    }

    @Override
    public PidType getPid(String pid) {
        log.debug((Object)("getPid(" + pid + ")"));
        return this.pidServiceClient.getPid(pid);
    }

    @Override
    public List<PidType> getPidByAttribute(String namingAuthority, String attributeValue) {
        log.debug((Object)("getPidByAttribute(" + namingAuthority + ", " + attributeValue + ")"));
        List<PidType> pids = this.pidServiceClient.getPidByAttribute(namingAuthority, attributeValue);
        log.debug(pids);
        return pids;
    }

    @Override
    public PidType getQuickPid(String namingAuthority, String localID, String resolveURL) {
        log.debug((Object)("getQuickPid(" + namingAuthority + ", " + localID + ", " + resolveURL + ")"));
        PidType p = this.pidServiceClient.getQuickPid(namingAuthority, localID, resolveURL);
        log.debug((Object)p);
        return p;
    }

    @Override
    public PidType update(String pid, String resolveURL, String localID, List<LocationType> locations) {
        log.debug((Object)("update(" + pid + ", " + resolveURL + ", " + localID + ", " + locations + ")"));
        return this.pidServiceClient.update(pid, resolveURL, localID, locations);
    }

    @Override
    public boolean isLocalIDBounded(String namingAuthority, String localID) {
        List<PidType> res = this.getPidByAttribute(namingAuthority, localID);
        if (res.size() > 1) {
            log.fatal((Object)("isLocalIDBounded got a list of " + res.size() + " PidType instead of 0 or 1. Please tell IISG the PID web service needs a method to check if a localID is already bounded (e.g., add attributeName parameter to the getPidByAttribute)"));
        }
        return res.size() > 0;
    }

    @Override
    public PidType reverseLookupByLocalID(String namingAuthority, String localID) {
        List<PidType> res = this.getPidByAttribute(namingAuthority, localID);
        if (res != null) {
            if (res.size() > 1) {
                log.fatal((Object)("reverseLookupByLocalID got a list of " + res.size() + " PidType instead of 0 or 1. Please tell IISG the PID web service needs a method to specify if we want the reverseLookup by localID or by resolveURL (e.g., add attributeName parameter to the getPidByAttribute)"));
            }
            if (res.size() >= 1) {
                return res.get(0);
            }
        }
        return null;
    }

    @Override
    public PidType reverseLookupByResolveURL(String namingAuthority, String resolveURL) {
        List<PidType> res = this.getPidByAttribute(namingAuthority, resolveURL);
        if (res.size() > 1) {
            log.fatal((Object)("reverseLookupByResolveURL got a list of " + res.size() + " PidType instead of 0 or 1. Please tell IISG the PID web service needs a method to specify if we want the reverseLookup by localID or by resolveURL (e.g., add attributeName parameter to the getPidByAttribute)"));
        }
        if (res.size() >= 1) {
            return res.get(0);
        }
        return null;
    }

    @Override
    public PidType updatePid(PidType pid) {
        log.debug((Object)("updatePid(" + pid + ")"));
        return this.pidServiceClient.updatePid(pid);
    }

    @Override
    public PidType upsert(String namingAuthority, String pid, String resolveURL, String localID, List<LocationType> locations) {
        log.debug((Object)("upsert(" + namingAuthority + ", " + pid + ", " + resolveURL + ", " + localID + ", " + locations + ")"));
        PidType p = this.pidServiceClient.upsert(namingAuthority, pid, resolveURL, localID, locations);
        log.debug((Object)p);
        return p;
    }

    public void setPidServiceClient(PidServiceClient pidServiceClient) {
        this.pidServiceClient = pidServiceClient;
    }

    public PidServiceClient getPidServiceClient() {
        return this.pidServiceClient;
    }
}

