/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.service;

import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.pid.service.PIDAssignerHelper;
import eu.dnetlib.pid.service.PIDAssignmentRule;
import eu.dnetlib.pid.service.PIDLocAttRule;
import eu.dnetlib.pid.service.rmi.PIDBridgeService;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.socialhistoryservices.pid.LocationType;
import org.socialhistoryservices.pid.PidType;

public class PIDUnaryFunction
implements UnaryFunction<String, String> {
    private static final Log log = LogFactory.getLog(PIDUnaryFunction.class);
    private Collection<PIDAssignmentRule> pidRules;
    private PIDBridgeService pidBridgeService;
    private String namingAuthority = "12345.1";
    private String unavailableURL = "http://node1.d.hope.research-infrastructures.eu/unavailable.html";
    private final String prefix_PID_URL = "http://hdl.handle.net/";
    private PIDAssignerHelper helper = new PIDAssignerHelper(this.unavailableURL);

    public String evaluate(String record) {
        log.debug((Object)"******EVALUATE********");
        try {
            Document doc;
            Document current = doc = new SAXReader().read((Reader)new StringReader(record));
            for (PIDAssignmentRule r : this.getPidRules()) {
                current = this.evaluate(current, r);
            }
            log.debug((Object)"******RECORD EVALUATED****************");
            return current.asXML();
        }
        catch (DocumentException e) {
            log.fatal((Object)"Cannot parse record to assign PID");
            throw new RuntimeException("Cannot parse record to assign PID", e);
        }
    }

    protected Document evaluate(Document d, PIDAssignmentRule r) {
        Document doc = d;
        String resolveURLPath = r.getResolveURLXPath();
        String objIdentifier = d.selectSingleNode(".//*[local-name()='record']/*[local-name() = 'header']/*[local-name() = 'objIdentifier']").getText();
        log.info((Object)("evaluating record objIdentifier: " + objIdentifier));
        Map<String, PIDLocAttRule> locattMap = r.getLocattRules();
        if (resolveURLPath != null && !resolveURLPath.isEmpty() && (locattMap == null || locattMap.isEmpty())) {
            return this.descriptiveUnitCase(doc, r, objIdentifier);
        }
        if ((resolveURLPath == null || resolveURLPath.isEmpty()) && (locattMap == null || locattMap.isEmpty())) {
            return this.referenceCase(doc, r, objIdentifier);
        }
        if ((resolveURLPath == null || resolveURLPath.isEmpty()) && locattMap != null && !locattMap.isEmpty()) {
            return this.digitalResourceCase(doc, r, objIdentifier);
        }
        return doc;
    }

    private Document descriptiveUnitCase(Document d, PIDAssignmentRule r, String objIdentifier) {
        log.info((Object)"CASE: descriptiveUnit");
        Document doc = d;
        String baseNodesPath = r.getBaseNodesXPath();
        String localIDPath = r.getLocalIDXPath();
        String targetPath = r.getTargetXPath();
        String resolveURLPath = r.getResolveURLXPath();
        List baseNodes = doc.selectNodes(baseNodesPath);
        for (Node n : baseNodes) {
            try {
                if (!this.helper.isNotBlank(n, localIDPath, objIdentifier)) continue;
                Node localIDNode = n.selectSingleNode(localIDPath);
                String localID = localIDNode.getText();
                Node targetNode = n.selectSingleNode(targetPath);
                if (targetNode == null) {
                    log.fatal((Object)("Expected target node at path: " + targetPath + " in record " + objIdentifier + " not found. PID not generated."));
                    break;
                }
                String resolveURL = this.helper.getResolveURL(n, resolveURLPath);
                PidType pid = this.upsertPID(localID, resolveURL, null);
                log.debug((Object)("upsert and cached pid " + pid.getPid() + " for localID " + localID));
                this.assign(n, pid, targetPath, r.getLocattRules());
            }
            catch (Exception e) {
                log.fatal((Object)("Cannot assign a PID for descriptive unit in record: " + objIdentifier + " at path: " + targetPath + " .\nCause: \n" + e));
                e.printStackTrace();
            }
        }
        return doc;
    }

    private Document referenceCase(Document d, PIDAssignmentRule r, String objIdentifier) {
        log.info((Object)"CASE: reference");
        Document doc = d;
        String baseNodesPath = r.getBaseNodesXPath();
        String localIDPath = r.getLocalIDXPath();
        String targetPath = r.getTargetXPath();
        List baseNodes = doc.selectNodes(baseNodesPath);
        for (Node n : baseNodes) {
            try {
                if (!this.helper.isNotBlank(n, localIDPath, objIdentifier)) continue;
                String localID = n.selectSingleNode(localIDPath).getText();
                Node targetNode = n.selectSingleNode(targetPath);
                if (targetNode == null) {
                    log.fatal((Object)("Expected target node at path: " + targetPath + " not found in record " + objIdentifier + ". PID not generated."));
                    break;
                }
                if (this.helper.isBlank(targetNode)) {
                    log.debug((Object)"PID to be fetched...getByAttribute or getQuickPid?");
                    PidType pid = null;
                    List<PidType> matching = this.pidBridgeService.getPidByAttribute(this.namingAuthority, localID);
                    if (matching.size() == 0) {
                        pid = this.pidBridgeService.getQuickPid(this.namingAuthority, localID, "");
                        log.debug((Object)(localID + " --> getquick pid: " + pid.getPid()));
                    } else {
                        if (matching.size() > 1) {
                            log.fatal((Object)("received more than one pid asking for attribute value, considering the first returned PID for " + localID));
                            log.fatal(matching);
                        }
                        pid = matching.get(0);
                        log.debug((Object)(localID + " --> got PID by localID attribute: " + pid.getPid()));
                    }
                    this.assign(n, pid, targetPath, r.getLocattRules());
                    continue;
                }
                log.debug((Object)(localID + " --> PID already there: nothing to do" + targetNode.getText()));
            }
            catch (Exception e) {
                log.fatal((Object)("Cannot assign a referenced PID in record: " + objIdentifier + " at path: " + targetPath + " .\nCause:\n" + e));
                e.printStackTrace();
            }
        }
        return doc;
    }

    private Document digitalResourceCase(Document d, PIDAssignmentRule r, String objIdentifier) {
        log.info((Object)"CASE: digitalResource");
        Document doc = d;
        String baseNodesPath = r.getBaseNodesXPath();
        String localIDPath = r.getLocalIDXPath();
        String targetPath = r.getTargetXPath();
        List baseNodes = doc.selectNodes(baseNodesPath);
        for (Node n : baseNodes) {
            try {
                if (!this.helper.isNotBlank(n, localIDPath, objIdentifier)) continue;
                String localID = n.selectSingleNode(localIDPath).getText();
                Node targetNode = n.selectSingleNode(targetPath);
                if (targetNode == null) {
                    log.fatal((Object)("Expected target node at path: " + targetPath + " not found in record " + objIdentifier + ". PID not generated."));
                    break;
                }
                PidType pid = this.getPIDByAttribute(localID);
                if (this.helper.isNotBlank(n, r.getLocattRules().get("level2").getResolveURLXPath(), objIdentifier)) {
                    log.debug((Object)(localID + " --> case with LOR"));
                    List<LocationType> locatts = this.helper.getLocationTypeList(r, n);
                    pid = this.upsertPID(localID, this.helper.getDerivative2URL(locatts), locatts);
                    this.assign(n, pid, targetPath, r.getLocattRules());
                    continue;
                }
                log.debug((Object)(localID + " --> case with SOR"));
                if (this.helper.isBlank(targetNode)) {
                    log.debug((Object)(localID + " --> PID to be fetched..."));
                    if (pid == null) {
                        pid = this.pidBridgeService.getQuickPid(this.namingAuthority, localID, "");
                        this.helper.setEmptyLocatts(pid);
                        log.debug((Object)(localID + " --> getquick pid: " + pid.getPid()));
                    }
                    this.assign(n, pid, targetPath, r.getLocattRules());
                    continue;
                }
                log.debug((Object)(localID + " --> PID already there: nothing to do" + targetNode.getText()));
            }
            catch (Exception e) {
                log.fatal((Object)("Cannot assign a PID in digitalResource: " + objIdentifier + " at path: " + targetPath + " .\nCause: " + e));
                e.printStackTrace();
            }
        }
        return doc;
    }

    private void assign(Node baseNode, PidType pidType, String targetXPath, Map<String, PIDLocAttRule> locattRules) {
        String pidURL = this.createFullURL(pidType.getPid());
        baseNode.selectSingleNode(targetXPath).setText(pidURL);
        if (locattRules != null && !locattRules.isEmpty()) {
            if (pidType.getLocAtt() == null) {
                log.fatal((Object)("LocattRules: " + locattRules));
                log.fatal((Object)("Unexpected null locations for PID: " + pidType.getPid() + " : can't assign derivative2 and derivative3 PIDs"));
                new Exception().printStackTrace();
            } else {
                this.assignLocs(baseNode, pidType, targetXPath, locattRules);
            }
        }
    }

    private void assignLocs(Node baseNode, PidType pidType, String targetXPath, Map<String, PIDLocAttRule> locattRules) {
        for (LocationType lt : pidType.getLocAtt().getLocation()) {
            PIDLocAttRule rule;
            if (lt == null || lt.getView() == null || lt.getView().isEmpty() || (rule = locattRules.get(lt.getView())) == null) continue;
            String ltarget = rule.getTargetXPath();
            String lresURL = rule.getResolveURLXPath();
            String locattURL = this.createFullURL(pidType.getPid() + "?locatt=view:" + lt.getView());
            baseNode.selectSingleNode(ltarget).setText(locattURL);
            baseNode.selectSingleNode(lresURL).setText(lt.getHref());
            log.debug((Object)("assigned locatt " + locattURL + " resolving to: " + lt.getHref() + " in relative xpath: " + ltarget + " baseNode is: " + baseNode.getPath()));
        }
    }

    private PidType getPIDByAttribute(String attribute) {
        PidType pid;
        List<PidType> matching = this.pidBridgeService.getPidByAttribute(this.namingAuthority, attribute);
        if (matching.size() == 0) {
            return null;
        }
        if (matching.size() > 1) {
            log.fatal((Object)("received more than one pid asking for attribute value, considering the first returned PID for " + attribute));
            log.fatal(matching);
            this.removePIDS(matching.subList(1, matching.size()));
        }
        if ((pid = matching.get(0)).getLocAtt() == null) {
            this.helper.setEmptyLocatts(pid);
        }
        return pid;
    }

    private void removePIDS(List<PidType> pidsToRemove) {
        log.fatal((Object)"Now deleting other pids");
        this.pidBridgeService.deleteListPids(pidsToRemove);
    }

    private PidType upsertPID(String localID, String resolveURL, List<LocationType> locationTypes) {
        PidType pid = this.pidBridgeService.upsert(this.namingAuthority, "", resolveURL, localID, locationTypes);
        return pid;
    }

    private String createFullURL(String suffix) {
        return "http://hdl.handle.net/" + suffix;
    }

    public PIDUnaryFunction() {
        this.pidRules = Lists.newArrayList();
    }

    public PIDUnaryFunction(Collection<PIDAssignmentRule> rules) {
        this.pidRules = rules;
    }

    public void addRule(PIDAssignmentRule r) {
        this.pidRules.add(r);
    }

    public void setPidRules(Collection<PIDAssignmentRule> pidRules) {
        this.pidRules = pidRules;
    }

    public Collection<PIDAssignmentRule> getPidRules() {
        return this.pidRules;
    }

    public String getNamingAuthority() {
        return this.namingAuthority;
    }

    public void setNamingAuthority(String namingAuthority) {
        this.namingAuthority = namingAuthority;
    }

    public PIDBridgeService getPidBridgeService() {
        return this.pidBridgeService;
    }

    public void setPidBridgeService(PIDBridgeService pidBridgeService) {
        this.pidBridgeService = pidBridgeService;
    }

    public String getUnavailableURL() {
        return this.unavailableURL;
    }

    public void setUnavailableURL(String unavailableURL) {
        this.unavailableURL = unavailableURL;
    }

    public PIDAssignerHelper getHelper() {
        return this.helper;
    }

    public void setHelper(PIDAssignerHelper helper) {
        this.helper = helper;
    }
}

