/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.service.mock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.socialhistoryservices.pid.CreatePidRequestType;
import org.socialhistoryservices.pid.CreatePidResponseType;
import org.socialhistoryservices.pid.DeletePidRequestType;
import org.socialhistoryservices.pid.DeletePidResponseType;
import org.socialhistoryservices.pid.DeletePidsRequestType;
import org.socialhistoryservices.pid.DeletePidsResponseType;
import org.socialhistoryservices.pid.GetPidByAttributeRequestType;
import org.socialhistoryservices.pid.GetPidByAttributeResponseType;
import org.socialhistoryservices.pid.GetPidRequestType;
import org.socialhistoryservices.pid.GetPidResponseType;
import org.socialhistoryservices.pid.GetQuickPidRequestType;
import org.socialhistoryservices.pid.GetQuickPidResponseType;
import org.socialhistoryservices.pid.PidResource;
import org.socialhistoryservices.pid.PidType;
import org.socialhistoryservices.pid.UpdatePidRequestType;
import org.socialhistoryservices.pid.UpdatePidResponseType;
import org.socialhistoryservices.pid.UpsertPidRequestType;
import org.socialhistoryservices.pid.UpsertPidResponseType;

public class PidResourceMock
implements PidResource {
    private static final Log log = LogFactory.getLog(PidResourceMock.class);

    @Override
    public CreatePidResponseType createPid(CreatePidRequestType createPidRequest) {
        CreatePidResponseType res = new CreatePidResponseType();
        PidType pid = createPidRequest.getHandle();
        pid.setPid("0");
        res.setHandle(pid);
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public DeletePidsResponseType deletePids(DeletePidsRequestType deletePidsRequest) {
        DeletePidsResponseType res = new DeletePidsResponseType();
        res.setCount(0L);
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public GetPidResponseType getPid(GetPidRequestType getPidRequest) {
        GetPidResponseType res = new GetPidResponseType();
        PidType pid = new PidType();
        pid.setPid(getPidRequest.getPid());
        pid.setLocalIdentifier("0");
        pid.setResolveUrl("http://mock");
        res.setHandle(pid);
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public GetPidByAttributeResponseType getPidByAttribute(GetPidByAttributeRequestType getPidByAttributeRequest) {
        GetPidByAttributeResponseType res = new GetPidByAttributeResponseType();
        String attr = getPidByAttributeRequest.getAttribute();
        String na = getPidByAttributeRequest.getNa();
        log.debug((Object)("Mock getPidByAttribute(" + attr + " , " + na + ")"));
        PidType pid = new PidType();
        pid.setPid("0");
        pid.setLocalIdentifier("0");
        pid.setResolveUrl("http://mock");
        res.getHandle().add(pid);
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public GetQuickPidResponseType getQuickPid(GetQuickPidRequestType getQuickPidRequest) {
        GetQuickPidResponseType res = new GetQuickPidResponseType();
        PidType pid = new PidType();
        pid.setLocalIdentifier(getQuickPidRequest.getLocalIdentifier());
        pid.setPid("0");
        pid.setResolveUrl(getQuickPidRequest.getResolveUrl());
        res.setHandle(pid);
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public UpdatePidResponseType updatePid(UpdatePidRequestType updatePidRequest) {
        UpdatePidResponseType res = new UpdatePidResponseType();
        res.setHandle(updatePidRequest.getHandle());
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public UpsertPidResponseType upsertPid(UpsertPidRequestType upsertPidRequest) {
        UpsertPidResponseType res = new UpsertPidResponseType();
        PidType pid = upsertPidRequest.getHandle();
        pid.setPid("0");
        res.setHandle(pid);
        log.debug((Object)("Mock response: " + res));
        return res;
    }

    @Override
    public DeletePidResponseType deletePid(DeletePidRequestType deletePidRequest) {
        DeletePidResponseType res = new DeletePidResponseType();
        res.setDeleted(true);
        log.debug((Object)("Mock response: " + res));
        return res;
    }
}

