/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.index.inspector;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceEnumerator;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.ServiceRunningInstance;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.string.EscapeHtml;
import eu.dnetlib.miscutils.functional.xml.IndentXmlString;
import eu.dnetlib.soap.cxf.CxfEndpointReferenceBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IndexInspector
extends AbstractInspectorController {
    private static final int PAGE_SIZE = 10;
    private static final Log log = LogFactory.getLog(IndexInspector.class);
    @Resource(name="anyIndexLocator")
    private ServiceLocator<IIndexService> indexLocator;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private ServiceResolver serviceResolver;
    @Resource(name="indexServiceEnumerator")
    private ServiceEnumerator<IIndexService> indexEnumerator;
    @Resource
    private CxfEndpointReferenceBuilder eprBuilder;
    @Resource
    private String localIndexServiceUrl;

    @RequestMapping(value={"/inspector/searchIndex.do"})
    public void search(Model model, @RequestParam(value="query", required=false) String query, @RequestParam(value="format", required=false) String format, @RequestParam(value="layout", required=false) String layout, @RequestParam(value="indexService", required=false) String indexServiceUrl, @RequestParam(value="indent", required=false) Boolean indent) throws IndexServiceException, ResultSetException, ISLookUpException {
        List indexServices = this.indexEnumerator.getServices();
        if (query != null) {
            List elements;
            log.info((Object)("running query: " + query + " on format " + format + " with layout " + layout));
            W3CEndpointReference indexEpr = indexServiceUrl == null || "".equals(indexServiceUrl) ? ((ServiceRunningInstance)indexServices.get(0)).getEpr() : this.eprBuilder.getEndpointReference(indexServiceUrl, null, null, null, null, null);
            IIndexService indexService = (IIndexService)this.serviceResolver.getService(IIndexService.class, indexEpr);
            W3CEndpointReference epr = indexService.indexLookup("all", query, format, layout);
            log.info((Object)("GOT EPR: " + epr));
            ResultSetService resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
            String rsId = this.serviceResolver.getResourceIdentifier(epr);
            int total = resultSet.getNumberOfElements(rsId);
            int pageSize = 10;
            if (total < pageSize) {
                pageSize = total;
            }
            if ((elements = resultSet.getResult(rsId, 1, pageSize, "waiting")) == null) {
                elements = new ArrayList();
            }
            if (indent != null && indent.booleanValue()) {
                elements = MappedCollection.listMap(elements, (UnaryFunction)new IndentXmlString());
            }
            List escaped = MappedCollection.listMap(elements, (UnaryFunction)new EscapeHtml());
            model.addAttribute("indent", (Object)indent);
            model.addAttribute("size", (Object)total);
            model.addAttribute("results", (Object)escaped);
        }
        List formats = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'IndexDSResourceType']//METADATA_FORMAT/text())");
        List layouts = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(for $x in //RESOURCE_PROFILE//LAYOUT/@name/string() order by $x return $x)");
        HashSet indices = Sets.newHashSet();
        for (ServiceRunningInstance index : indexServices) {
            indices.add(index.getUrl());
        }
        indices.add(this.localIndexServiceUrl);
        model.addAttribute("indexServices", this.selectOptions(Lists.newArrayList((Iterable)indices), indexServiceUrl));
        model.addAttribute("formats", this.selectOptions(formats, format));
        model.addAttribute("layouts", this.selectOptions(layouts, layout));
        model.addAttribute("query", (Object)query);
    }

    @RequestMapping(value={"/inspector/browseIndex.do"})
    public void browse(Model model, @RequestParam(value="query", required=false) String querySource, @RequestParam(value="field", required=false) String browseField, @RequestParam(value="idxId", required=false) String idxId, @RequestParam(value="indexService", required=false) String indexServiceUrl, @RequestParam(value="format", required=false) String format, @RequestParam(value="layout", required=false) String layout, @RequestParam(value="start", required=false) Integer startParam, @RequestParam(value="indent", required=false) Boolean indent) throws IndexServiceException, ResultSetException, ISLookUpException, UnsupportedEncodingException {
        long starting;
        long elapsed = starting = System.currentTimeMillis();
        int total = 0;
        int start = 0;
        int pageSize = 10;
        List indexServices = this.indexEnumerator.getServices();
        if (startParam != null) {
            start = startParam;
        }
        if (browseField != null) {
            List elements;
            log.info((Object)("browsing field: " + browseField + " on format " + format + " with layout " + layout));
            String query = "query=" + querySource + "&groupby=" + browseField;
            W3CEndpointReference indexEpr = indexServiceUrl == null || "".equals(indexServiceUrl) ? ((ServiceRunningInstance)indexServices.get(0)).getEpr() : this.eprBuilder.getEndpointReference(indexServiceUrl, null, null, null, null, null);
            IIndexService indexService = (IIndexService)this.serviceResolver.getService(IIndexService.class, indexEpr);
            W3CEndpointReference epr = indexService.getBrowsingStatistics(query, idxId, format, layout);
            log.debug((Object)("GOT EPR: " + epr));
            ResultSetService resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
            String rsId = this.serviceResolver.getResourceIdentifier(epr);
            total = resultSet.getNumberOfElements(rsId);
            if (total < pageSize) {
                pageSize = total;
            }
            if ((elements = resultSet.getResult(rsId, 1 + start, start + pageSize, "waiting")) == null) {
                elements = new ArrayList();
            }
            if (indent != null && indent.booleanValue()) {
                elements = MappedCollection.listMap(elements, (UnaryFunction)new IndentXmlString());
            }
            List escaped = MappedCollection.listMap(elements, (UnaryFunction)new EscapeHtml());
            elapsed = System.currentTimeMillis() - starting;
            model.addAttribute("results", (Object)escaped);
            model.addAttribute("elapsed", (Object)HumanTime.exactly((long)elapsed));
        }
        List fields = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(//RESOURCE_PROFILE//LAYOUT//FIELD/@browsingAliasFor/string())");
        List formats = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'IndexDSResourceType']//METADATA_FORMAT/text())");
        List layouts = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(for $x in //RESOURCE_PROFILE//LAYOUT/@name/string() order by $x return $x)");
        List idxIds = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value = 'IndexDSResourceType']/@value/string()");
        idxIds.add(0, "all");
        HashSet indices = Sets.newHashSet();
        for (ServiceRunningInstance index : indexServices) {
            indices.add(index.getUrl());
        }
        indices.add(this.localIndexServiceUrl);
        if (querySource == null || querySource.equals("")) {
            querySource = "textual";
        }
        model.addAttribute("indexServices", this.selectOptions(Lists.newArrayList((Iterable)indices), indexServiceUrl));
        model.addAttribute("encodedQuerySource", (Object)URLEncoder.encode(querySource, "UTF-8"));
        model.addAttribute("querySource", (Object)querySource);
        model.addAttribute("total", (Object)total);
        model.addAttribute("start", (Object)start);
        model.addAttribute("nextPage", (Object)(start + pageSize));
        model.addAttribute("prevPage", (Object)Math.max(0, start - pageSize));
        model.addAttribute("indent", (Object)indent);
        model.addAttribute("browseField", (Object)browseField);
        model.addAttribute("fields", this.selectOptions(fields, browseField));
        model.addAttribute("idxIds", this.selectOptions(idxIds, idxId));
        model.addAttribute("formats", this.selectOptions(formats, format));
        model.addAttribute("layouts", this.selectOptions(layouts, layout));
    }

    private List<SelectOption> selectOptions(List<String> input, final String current) {
        return MappedCollection.listMap(input, (UnaryFunction)new UnaryFunction<SelectOption, String>(){

            public SelectOption evaluate(String value) {
                return new SelectOption(value, value.equals(current));
            }
        });
    }

    public ServiceLocator<IIndexService> getIndexLocator() {
        return this.indexLocator;
    }

    public void setIndexLocator(ServiceLocator<IIndexService> indexLocator) {
        this.indexLocator = indexLocator;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public static class SelectOption {
        private String value;
        private boolean selected;

        public SelectOption(String value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

