package eu.dnetlib.functionality.index.solr.utils;

import org.springframework.beans.factory.annotation.Required;

public class MetadataReferenceFactory {

	/**
	 * Default interpretation, to be used for the lookup method which doesn't have an interpretation parameter.
	 */
	private String interpretation;

	public MetadataReference getMetadata(final String format, final String layout, final String interpretation) {
		return new MetadataReference(format, layout, interpretation);
	}
	
	public MetadataReference getMetadata(final String format, final String layout) {
		return getMetadata(format, layout, interpretation);
	}
	
	public MetadataReference decodeMetadata(final String encoded) {
		String[] split = encoded.split("-");
		if (split.length == 3) 
			return getMetadata(split[0], split[1], split[2]);
		
		if (split.length == 2) 
			return getMetadata(split[0], split[1]);
		
		throw new IllegalStateException("malformed metadata reference: " + encoded);
	}
	
	@Required
	public void setInterpretation(String interpretation) {
		this.interpretation = interpretation;
	}

	public String getInterpretation() {
		return interpretation;
	}
	
}