package eu.dnetlib.functionality.index.solr.utils;

import java.io.StringReader;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XmlUtils {

	/**
	 * helper method, parses a list of fields.
	 * 
	 * @param fields
	 *            the given fields
	 * @return the parsed fields
	 * @throws IndexServiceException
	 *             if cannot parse the fields
	 */
	public static Document parse(String xml) {
		try {
			return new SAXReader().read(new StringReader(xml));
		} catch (DocumentException e) {
			throw new IllegalArgumentException("cannot parse: " + xml);
		}
	}

	public static InputSource asInputSource(final String input) throws DocumentException {
		return new InputSource(new StringReader(parse(input).asXML()));
	}
}
