package eu.dnetlib.inspector.security;

import java.util.Map;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;

/**
 * Simple static user details service for spring security. It allows us to use placeholder configurer for injecting md5
 * passwords from configuration files.
 * 
 * @author marko
 * 
 */
public class InspectorUserService implements UserDetailsService {

	private Map<String, UserDetails> userMap;

	public UserDetails loadUserByUsername(String name) {
		return userMap.get(name);
	}

	public Map<String, UserDetails> getUserMap() {
		return userMap;
	}

	@Required
	public void setUserMap(Map<String, UserDetails> userMap) {
		this.userMap = userMap;
	}

}
