package eu.dnetlib.management.log4j;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;

/**
 * Exports log level control via jmx.
 * 
 * @author marko
 * 
 */
public class Log4JMBean {

	/**
	 * Logger.
	 */
	private static final Log log = LogFactory.getLog(Log4JMBean.class); // NOPMD by marko on 11/24/08 5:02 PM

	public void setLogger(final String category, final String level) {
		log.info("setting log level for package '" + category + "' to: " + level);
		LogManager.getLogger(category).setLevel(Level.toLevel(level));
	}
}
