/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter;

import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.openaire.exporter.ProjectQueryParams;
import eu.dnetlib.openaire.exporter.ProjectQueryParamsFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class ProjectsController {
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String dbName;
    private org.springframework.core.io.Resource dspaceXslt;
    private org.springframework.core.io.Resource eprintsXslt;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    private ProjectQueryParamsFactory projectQueryParamsFactory;
    private static final Log log = LogFactory.getLog(ProjectsController.class);

    @RequestMapping(value={"/openaire/export/**/project/dspace.do"})
    void processDspace(HttpServletRequest request, ServletResponse response, @RequestParam(value="startFrom", required=false) String startFrom, @RequestParam(value="startUntil", required=false) String startUntil, @RequestParam(value="endFrom", required=false) String endFrom, @RequestParam(value="endUntil", required=false) String endUntil) throws Exception {
        response.setContentType("text/xml");
        ProjectQueryParams params = this.projectQueryParamsFactory.generateParams(request, startFrom, startUntil, endFrom, endUntil);
        ServletOutputStream out = response.getOutputStream();
        String head = "<?xml version='1.0' encoding='UTF-8'?>\n\n<form-value-pairs>\n\t<value-pairs value-pairs-name='" + params.getFundingProgramme() + "projects' dc-term='relation'>\n";
        String tail = "\t</value-pairs>\n</form-value-pairs>\n";
        IOUtils.copy((Reader)new StringReader(head), (OutputStream)out);
        this.emit((OutputStream)out, this.dspaceXslt, this.obtainQuery(params));
        IOUtils.copy((Reader)new StringReader(tail), (OutputStream)out);
    }

    @RequestMapping(value={"/openaire/export/**/project/eprints.do"})
    void processEprints(HttpServletRequest request, ServletResponse response, @RequestParam(value="startFrom", required=false) String startFrom, @RequestParam(value="startUntil", required=false) String startUntil, @RequestParam(value="endFrom", required=false) String endFrom, @RequestParam(value="endUntil", required=false) String endUntil) throws Exception {
        response.setContentType("text/html");
        this.emit((OutputStream)response.getOutputStream(), this.eprintsXslt, this.obtainQuery(this.projectQueryParamsFactory.generateParams(request, startFrom, startUntil, endFrom, endUntil)));
    }

    private String obtainQuery(ProjectQueryParams params) {
        String query = "select p.acronym as acronym, p.title as title, regexp_replace(p.id, '^ec::'  , '') as grant_agreement_number, p.startdate as start_date, p.enddate as end_date, f1.name as subdivision, f2.name as specificprogramme, f3.name as fundingprogramme from projects p left outer join project_funding pf on (p.id = pf.project) left outer join funding_funding ff1 on (pf.funding = ff1.funding1) left outer join funding_funding ff2 on (ff1.funding2 = ff2.funding1) left outer join fundings f1 on (f1.id = ff1.funding1) left outer join fundings f2 on (f2.id = ff2.funding1) left outer join fundings f3 on (f3.id = ff2.funding2) where f3.id = 'ec::FP7' ";
        if (params.getSubdivision() != null) {
            query = query + "AND f1.name = '" + params.getSubdivision() + "'";
        }
        if (params.getSpecificProgramme() != null) {
            query = query + "AND f2.name = '" + params.getSpecificProgramme() + "'";
        }
        if (params.getFundingProgramme() != null) {
            query = query + "AND f3.name = '" + params.getFundingProgramme() + "'";
        }
        if (params.getStartFrom() != null) {
            query = query + "AND p.startdate >= '" + params.getStartFrom() + "'";
        }
        if (params.getStartUntil() != null) {
            query = query + "AND p.startdate <= '" + params.getStartUntil() + "'";
        }
        if (params.getEndFrom() != null) {
            query = query + "AND p.enddate >= '" + params.getEndFrom() + "'";
        }
        if (params.getEndUntil() != null) {
            query = query + "AND p.enddate <= '" + params.getEndUntil() + "'";
        }
        log.info((Object)("Executing query: " + query));
        return query;
    }

    void emit(OutputStream out, org.springframework.core.io.Resource xslt, String query) throws IOException {
        W3CEndpointReference epr = ((DatabaseService)this.dbServiceLocator.getService()).searchSQL(this.dbName, query);
        IterableResultSetClient iter = this.resultSetClientFactory.getClient(epr);
        for (String s : new MappedCollection((Iterable)iter, (UnaryFunction)new ApplyXslt(xslt))) {
            out.write(s.getBytes());
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    @Required
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public org.springframework.core.io.Resource getDspaceXslt() {
        return this.dspaceXslt;
    }

    @Required
    public void setDspaceXslt(org.springframework.core.io.Resource dspaceXslt) {
        this.dspaceXslt = dspaceXslt;
    }

    public org.springframework.core.io.Resource getEprintsXslt() {
        return this.eprintsXslt;
    }

    @Required
    public void setEprintsXslt(org.springframework.core.io.Resource eprintsXslt) {
        this.eprintsXslt = eprintsXslt;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public ProjectQueryParamsFactory getProjectQueryParamsFactory() {
        return this.projectQueryParamsFactory;
    }

    @Required
    public void setProjectQueryParamsFactory(ProjectQueryParamsFactory projectQueryParamsFactory) {
        this.projectQueryParamsFactory = projectQueryParamsFactory;
    }
}

