<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="xsl xsi">

	<xsl:output omit-xml-declaration="yes" standalone="no" indent="yes"/>
	
	<xsl:template match="/">
		<xsl:variable name="id" select="//FIELD[@name='grant_agreement_number']" />
		<xsl:variable name="title" select="//FIELD[@name='title']" />
		<xsl:variable name="acronym" select="//FIELD[@name='acronym']" />
		
		<xsl:value-of select="concat($acronym, ' - ', $title)" />
		<li style='border-right: solid 50px #30FF30' >
			<xsl:value-of select="concat($id, ' - ', $acronym, ' - ', $title)" />
			<ul>
				<li id="for:value:component:_fp7_project_id"><xsl:value-of select="concat('info:eu-repo/grantAgreement/EC/FP7/', $id)" /></li>
			</ul>
		</li>
	</xsl:template>

</xsl:stylesheet>