/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.client;

import eu.dnetlib.enabling.resultset.client.utils.ResultSetRuntimeException;
import eu.dnetlib.enabling.resultset.client.utils.ResultSetTimeoutException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetPageProvider {
    private static final Log log = LogFactory.getLog(ResultSetPageProvider.class);
    private final ResultSetService resultSet;
    private final String rsId;
    private int fromPosition;
    private int toPosition;
    private int pageSize;
    private static int DEFAULT_PAGE_SIZE = 10;
    private static long DEFAULT_MAX_WAIT_TIME = 30000L;
    private long maxWaitTime;
    private long waitTime;
    private int delayCount;
    private String RSStatus;
    private int numberOfElements;
    private static final String RS_CLOSED = "closed";
    private static final String RS_OPEN = "open";

    public ResultSetPageProvider(ResultSetService resultSet, String rsId) throws ResultSetRuntimeException {
        this.resultSet = resultSet;
        this.rsId = rsId;
        this.pageSize = DEFAULT_PAGE_SIZE;
        this.maxWaitTime = DEFAULT_MAX_WAIT_TIME;
        this.toPosition = 0;
        this.fromPosition = 0;
        this.delayCount = 0;
        this.waitTime = 0L;
        this.updateResultSetStatus();
    }

    public ResultSetPageProvider(ResultSetService resultSet, String rsId, int pageSize) throws ResultSetRuntimeException {
        this(resultSet, rsId);
        this.pageSize = pageSize;
    }

    public List<String> nextPage() throws ResultSetTimeoutException, ResultSetRuntimeException {
        while (true) {
            this.updateResultSetStatus();
            int availableElements = this.numberOfElements - this.toPosition;
            if (availableElements > 0) {
                this.fromPosition = this.toPosition + 1;
                if (availableElements < this.pageSize) {
                    this.toPosition = this.fromPosition + availableElements - 1;
                } else {
                    this.toPosition = this.fromPosition + this.pageSize - 1;
                    this.delayCount = 0;
                }
                try {
                    return this.resultSet.getResult(this.rsId, this.fromPosition, this.toPosition, "waiting");
                }
                catch (ResultSetException e) {
                    log.info((Object)e);
                    throw new NoSuchElementException(e.getMessage());
                }
            }
            if (this.RSStatus.equals(RS_CLOSED) && availableElements == 0) {
                return null;
            }
            this.stopAndWait(++this.delayCount);
        }
    }

    private void stopAndWait(int delayCount) throws ResultSetTimeoutException {
        try {
            this.waitTime = (long)(Math.pow(1.2, 10 + delayCount) * 10.0) + 200L;
            if (this.waitTime > this.maxWaitTime) {
                log.warn((Object)("Timeout getting elements from resultset: " + this.waitTime + ". next poll would wait more than " + this.maxWaitTime + " ms"));
                throw new ResultSetTimeoutException("Timeout getting elements from resultset: next poll would wait more than " + this.maxWaitTime + " ms");
            }
            log.debug((Object)("resultset client is going to sleep for: " + this.waitTime));
            Thread.sleep(this.waitTime);
        }
        catch (InterruptedException e) {
            log.error((Object)"resultSetClient got InterruptedException", (Throwable)e);
        }
    }

    private void updateResultSetStatus() throws ResultSetRuntimeException {
        try {
            this.RSStatus = this.resultSet.getRSStatus(this.rsId);
            this.numberOfElements = this.resultSet.getNumberOfElements(this.rsId);
        }
        catch (ResultSetException e) {
            log.warn((Object)e);
            throw new ResultSetRuntimeException(e);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("parameter 'pageSize' must be grater than zero");
        }
        this.pageSize = pageSize;
    }

    @Deprecated
    public boolean hasElements() throws ResultSetRuntimeException {
        this.updateResultSetStatus();
        if (this.RSStatus.equals(RS_OPEN)) {
            return true;
        }
        return !this.RSStatus.equals(RS_CLOSED) || this.numberOfElements != 0;
    }

    public void setMaxWaitTime(long maxWaitTime) {
        if (maxWaitTime <= 0L) {
            throw new IllegalArgumentException("parameter 'maxWaitTime' must be grater than zero");
        }
        this.maxWaitTime = maxWaitTime;
    }
}

