package eu.dnetlib.enabling.resultset.client;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;

/**
 * 
 * @author claudio
 * 
 */
public class ResultSetClientFactory implements ResultSetClient {

	/**
	 * logger
	 */
	private static final Log log = LogFactory.getLog(ResultSetClientFactory.class);

	/**
	 * used to resolve the epr references to the service endpoint
	 */
	private ServiceResolver serviceResolver;

	/**
	 * utility object
	 */
	private EPRUtils eprUtils;

	/**
	 * actual page size
	 */
	private int pageSize;

	/**
	 * actual timeout
	 */
	private long timeout;

	public ResultSetClientFactory() {
		log.info("creating new ResultSetClientIterableFactory with default pageSize and timeout");
	}

	/**
	 * 
	 * @param pageSize
	 * @param timeout
	 * @throws IllegalArgumentException
	 */
	public ResultSetClientFactory(int pageSize, long timeout) throws IllegalArgumentException {
		if (pageSize <= 0 || timeout <= 0)
			throw new IllegalArgumentException("parameters pageSize and timeout must be greater than zero");
		this.pageSize = pageSize;
		this.timeout = timeout;
	}

	/**
	 * 
	 * @param epr
	 * @param pageSize
	 * @return
	 */
	@Override
	public IterableResultSetClient getClient(W3CEndpointReference epr, int pageSize) {
		final ResultSetService resultSet = serviceResolver.getService(ResultSetService.class, epr);
		final String rsId = serviceResolver.getResourceIdentifier(epr);

		//using given pageSize and default timeout
		return new IterableResultSetClient(resultSet, rsId, pageSize, timeout);
	}

	/**
	 * 
	 * @param epr
	 * @return
	 */
	@Override
	public IterableResultSetClient getClient(W3CEndpointReference epr) {
		final ResultSetService resultSet = serviceResolver.getService(ResultSetService.class, epr);
		final String rsId = serviceResolver.getResourceIdentifier(epr);

		//using default pageSize and timeout
		return new IterableResultSetClient(resultSet, rsId, pageSize, timeout);
	}

	/**
	 * 
	 * @param stringEpr
	 * @param pageSize
	 * @return
	 */
	@Override
	public IterableResultSetClient getClient(String stringEpr, int pageSize) {
		return getClient(eprUtils.getEpr(stringEpr), pageSize);
	}

	/**
	 * 
	 * @param stringEpr
	 * @return
	 */
	@Override
	public IterableResultSetClient getClient(String stringEpr) {
		return getClient(eprUtils.getEpr(stringEpr));
	}

	@Required
	public void setServiceResolver(ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

	@Required
	public void setEprUtils(EPRUtils eprUtils) {
		this.eprUtils = eprUtils;
	}

	public int getPageSize() {
		return pageSize;
	}

	@Required
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public long getTimeout() {
		return timeout;
	}

	@Required
	public void setTimeout(long timeout) {
		this.timeout = timeout;
	}

}
