/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetRegistry;
import eu.dnetlib.enabling.resultset.observer.DelegationObserver;
import eu.dnetlib.enabling.resultset.observer.Observable;
import java.util.Map;
import java.util.Observer;
import java.util.WeakHashMap;

public abstract class AbstractObservableResultset
implements ResultSet,
Observable {
    private boolean destroyed = false;
    private boolean open;
    private final transient java.util.Observable observable = new DelegationObservable();
    private transient Map<ResultSetRegistry, DelegationObserver> observers = new WeakHashMap<ResultSetRegistry, DelegationObserver>();

    @Override
    public void destroy() {
        if (!this.isDestroyed()) {
            this.setDestroyed(true);
            this.notifyObservers();
            this.deleteObservers();
        }
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.open = false;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public void addObserver(ResultSetRegistry observer) {
        DelegationObserver delegate = new DelegationObserver(this, observer);
        this.observers.put(observer, delegate);
        this.observable.addObserver(delegate);
    }

    protected void notifyObservers() {
        this.observable.notifyObservers();
    }

    protected void notifyObservers(Object arg) {
        this.observable.notifyObservers(arg);
    }

    public int countObservers() {
        return this.observable.countObservers();
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    public void deleteObserver(ResultSetRegistry observer) {
        DelegationObserver delegate = this.observers.get(observer);
        if (delegate != null) {
            this.observable.deleteObserver(delegate);
        }
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    static class DelegationObservable
    extends java.util.Observable {
        DelegationObservable() {
        }

        @Override
        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers();
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }
}

